/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.openapi.v2;

import java.sql.Timestamp;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.openapi.common.constant.ApiDefType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.api.ApiClassify;
import kd.isc.iscb.platform.core.api.openapi.OpenApi;
import kd.isc.iscb.platform.core.api.openapi.OpenApiBuilder;
import kd.isc.iscb.platform.core.util.CommonUtil;

public abstract class OpenApiVersion2Builder
implements OpenApiBuilder {
    protected static final String DISPATCHER_CLASS_NAME = "kd.isc.iscb.platform.core.api.OpenApiVersion2Dispatcher";
    protected static final String DISPATCH_METHOD = "route";

    @Override
    public DynamicObject buildApiServiceAndSave(DynamicObject iscApi) {
        return this.buildOpen2ApiByDynamic(iscApi);
    }

    private DynamicObject getOpenApiDynamicObject(DynamicObject iscApi) {
        String number = ApiClassify.getPrefix(iscApi.getDataEntityType().getName()) + iscApi.get("number");
        DynamicObject openApi = OpenApi.getOpenApi(number, "openapi_customapi");
        if (openApi == null) {
            DynamicObject svc = BusinessDataServiceHelper.newDynamicObject((String)"openapi_customapi");
            svc.set("creator", (Object)1);
            svc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
            return svc;
        }
        return BusinessDataServiceHelper.loadSingle((Object)openApi.getPkValue(), (String)"openapi_customapi");
    }

    public DynamicObject buildOpen2ApiByDynamic(DynamicObject iscApi) {
        DynamicObject svc = this.getOpenApiDynamicObject(iscApi);
        String openApiNumber = this.getOpenApiNumber(iscApi);
        svc.set("number", (Object)openApiNumber);
        svc.set("urlformat", (Object)("/v2/iscb/route/" + openApiNumber));
        svc.set("name", (Object)iscApi.getString("name"));
        svc.set("appid", (Object)"TV3/VDJ86RC");
        svc.set("apiservicetype", (Object)2);
        svc.set("enable", (Object)1);
        svc.set("status", (Object)"C");
        svc.set("httpmethod", (Object)1);
        svc.set("modifier", (Object)1);
        svc.set("version", (Object)"2");
        svc.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        svc.set("classname", (Object)DISPATCHER_CLASS_NAME);
        svc.set("methodname", (Object)DISPATCH_METHOD);
        svc.set("customsort", (Object)1338403334104677376L);
        svc.set("apideftype", (Object)ApiDefType.WSDL.getCode());
        this.appendBaseInfo(svc, iscApi);
        svc.set("bodyentryentity", (Object)this.makeBodyEntries(svc, iscApi));
        svc.set("respentryentity", (Object)this.makeRespEntries(svc, iscApi));
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"openapi_customapi", (DynamicObject[])new DynamicObject[]{svc}, (OperateOption)CommonUtil.getSkipPermissionOption());
        CommonUtil.check(result);
        return svc;
    }

    protected void appendBaseInfo(DynamicObject svc, DynamicObject api) {
        svc.set("namespace", api.get("namespace"));
        svc.set("wsinputparam", api.get("wsinputparam"));
        svc.set("wsoutputparam", api.get("wsoutputparam"));
        if (svc.containsProperty("wsmethodname")) {
            svc.set("wsmethodname", api.get("number"));
        }
    }

    protected abstract DynamicObjectCollection makeBodyEntries(DynamicObject var1, DynamicObject var2);

    protected abstract DynamicObjectCollection makeRespEntries(DynamicObject var1, DynamicObject var2);
}

