/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.api.parsers.ApiParser;
import kd.isc.iscb.platform.core.api.parsers.model.Model;
import kd.isc.iscb.platform.core.api.parsers.model.SwaggerField;
import kd.isc.iscb.platform.core.api.parsers.model.SwaggerModel;
import kd.isc.iscb.util.dt.D;
import org.yaml.snakeyaml.Yaml;

public class SwaggerApiParser
implements ApiParser {
    private Map<String, Object> root;

    @Override
    public Model parse(String text) {
        return null;
    }

    @Override
    public List<Model> parseMulti(String text) {
        Yaml yaml = new Yaml();
        this.root = (Map)yaml.load(text);
        ArrayList<Model> swaggerModels = new ArrayList<Model>();
        Map paths = (Map)this.root.get("paths");
        for (Map.Entry entry : paths.entrySet()) {
            String path = (String)entry.getKey();
            Map operations = (Map)entry.getValue();
            for (Map.Entry opEntry : operations.entrySet()) {
                String method = (String)opEntry.getKey();
                if (!(opEntry.getValue() instanceof Map)) continue;
                Map operation = (Map)opEntry.getValue();
                SwaggerModel swaggerModel = this.parseOperation(path, method, operation);
                swaggerModels.add(swaggerModel);
            }
        }
        return swaggerModels;
    }

    private SwaggerModel parseOperation(String path, String method, Map<String, Object> operation) {
        String url = this.getServerUrl() + path;
        List<SwaggerField> urlParameters = this.parseUrlParams((List)operation.get("parameters"));
        List<SwaggerField> headers = this.parseHeaders((List)operation.get("parameters"));
        List<SwaggerField> requestBody = this.parseRequestBody((Map)operation.get("requestBody"));
        String httpMethod = method.toUpperCase();
        List<SwaggerField> responses = this.parseResponses((Map)operation.get("responses"));
        return new SwaggerModel(url, httpMethod, urlParameters, headers, requestBody, responses);
    }

    private List<SwaggerField> parseParameters(List<Map<String, Object>> parameters, String parameterType) {
        ArrayList<SwaggerField> fields = new ArrayList<SwaggerField>();
        if (parameters != null) {
            for (Map<String, Object> parameter : parameters) {
                if (parameter == null || !parameterType.equals(parameter.get("in"))) continue;
                String name = D.s((Object)parameter.get("name"));
                String description = D.s((Object)parameter.get("description"));
                boolean required = D.x((Object)parameter.get("required"));
                String type = this.getType(parameter);
                boolean isArray = this.isArray(parameter);
                Object defaultValue = this.getDefaultValue(parameter);
                SwaggerField field = new SwaggerField(name, description, required, type, isArray, defaultValue, null, null, null);
                fields.add(field);
            }
        }
        return fields;
    }

    private boolean isArray(Map<String, Object> parameter) {
        Object schema = parameter.get("schema");
        if (schema instanceof Map) {
            String type = D.s(((Map)schema).get("type"));
            return "array".equalsIgnoreCase(type);
        }
        return false;
    }

    private List<SwaggerField> parseUrlParams(List<Map<String, Object>> parameters) {
        return this.parseParameters(parameters, "query");
    }

    private List<SwaggerField> parseHeaders(List<Map<String, Object>> parameters) {
        return this.parseParameters(parameters, "header");
    }

    private String getServerUrl() {
        List servers = (List)this.root.get("servers");
        if (servers != null && !servers.isEmpty()) {
            Map server = (Map)servers.get(0);
            return D.s(server.get("url"));
        }
        return "http://127.0.0.1:80";
    }

    private Object getDefaultValue(Map<String, Object> obj) {
        Map schema;
        Object defaultValue = obj.get("default");
        if (defaultValue == null && (schema = (Map)obj.get("schema")) != null) {
            defaultValue = this.getDefaultValue(schema);
        }
        return defaultValue;
    }

    private String getType(Map<String, Object> obj) {
        boolean isArray;
        Map schema;
        String type = D.s((Object)obj.get("type"));
        if (type == null && (schema = (Map)obj.get("schema")) != null) {
            type = this.getType(schema);
        }
        if (type == null) {
            type = "string";
        }
        if (isArray = "array".equals(type)) {
            Map items = (Map)obj.get("items");
            type = items != null ? this.getType(items) : "string";
        }
        return type;
    }

    private List<SwaggerField> resolveRef(String ref) {
        ArrayList<SwaggerField> fields = new ArrayList<SwaggerField>();
        if (ref.startsWith("#/components/schemas/")) {
            String schemaName = ref.substring("#/components/schemas/".length());
            Map schemas = (Map)this.root.get("components");
            if (schemas != null && schemas.containsKey("schemas")) {
                Map schemaMap = (Map)schemas.get("schemas");
                Map schema = (Map)schemaMap.get(schemaName);
                fields.addAll(this.parseSchema(schema));
            }
        }
        return fields;
    }

    private SwaggerField parseField(String name, Map<String, Object> property, List<String> requiredProperties, boolean required) {
        if (property.containsKey("$ref")) {
            String ref = D.s((Object)property.get("$ref"));
            return this.resolveRef(ref).get(0);
        }
        boolean isArray = "array".equals(property.get("type"));
        String type = isArray ? this.getType((Map)property.get("items")) : this.getType(property);
        Object defaultValue = this.getDefaultValue(property);
        Object exampleValue = property.get("example");
        String description = D.s((Object)property.get("description"));
        List<Object> subProperties = new ArrayList();
        if (isArray) {
            Map items = (Map)property.get("items");
            if (items != null && "object".equals(type)) {
                subProperties = this.parseSchema(items);
            }
        } else if ("object".equals(type)) {
            subProperties = this.parseSchema(property);
        }
        return new SwaggerField(name, description, required, type, isArray, defaultValue, exampleValue, subProperties, requiredProperties);
    }

    private List<SwaggerField> parseSchema(Map<String, Object> schema) {
        ArrayList<SwaggerField> fields = new ArrayList<SwaggerField>();
        if (schema != null) {
            if (schema.containsKey("$ref")) {
                String ref = D.s((Object)schema.get("$ref"));
                fields.addAll(this.resolveRef(ref));
            } else {
                boolean isArray = "array".equals(schema.get("type"));
                if (isArray) {
                    Map items = (Map)schema.get("items");
                    if (items != null) {
                        fields.addAll(this.parseSchema(items));
                    }
                } else if ("object".equals(schema.get("type")) && schema.containsKey("properties")) {
                    Map properties = (Map)schema.get("properties");
                    List requiredProperties = (List)schema.get("required");
                    for (Map.Entry entry : properties.entrySet()) {
                        String name = (String)entry.getKey();
                        if (requiredProperties == null && entry.getValue() instanceof Map) {
                            requiredProperties = (List)((Map)entry.getValue()).get("required");
                        }
                        Map property = (Map)entry.getValue();
                        boolean required = requiredProperties != null && requiredProperties.contains(name);
                        fields.add(this.parseField(name, property, requiredProperties, required));
                    }
                }
            }
        }
        return fields;
    }

    private List<SwaggerField> parseRequestBody(Map<String, Object> requestBody) {
        Map content;
        ArrayList<SwaggerField> fields = new ArrayList<SwaggerField>();
        if (requestBody != null && (content = (Map)requestBody.get("content")) != null) {
            for (Map.Entry entry : content.entrySet()) {
                Map mediaType = (Map)entry.getValue();
                if (!mediaType.containsKey("schema")) continue;
                Map schema = (Map)mediaType.get("schema");
                if (schema.containsKey("$ref")) {
                    String ref = D.s(schema.get("$ref"));
                    fields.addAll(this.resolveRef(ref));
                    continue;
                }
                if (schema.containsKey("additionalProperties")) {
                    Map additionalProperties = (Map)schema.get("additionalProperties");
                    fields.addAll(this.parseSchema(additionalProperties));
                    continue;
                }
                fields.addAll(this.parseSchema(schema));
            }
        }
        return fields;
    }

    private List<SwaggerField> parseResponses(Map<String, Object> responses) {
        ArrayList<SwaggerField> fields = new ArrayList<SwaggerField>();
        if (responses != null) {
            for (Map.Entry<String, Object> entry : responses.entrySet()) {
                Map response = (Map)entry.getValue();
                Map content = (Map)response.get("content");
                if (content == null) continue;
                for (Map.Entry contentEntry : content.entrySet()) {
                    Map mediaType = (Map)contentEntry.getValue();
                    if (!mediaType.containsKey("schema")) continue;
                    Map schema = (Map)mediaType.get("schema");
                    if (schema.containsKey("$ref")) {
                        String ref = D.s(schema.get("$ref"));
                        fields.addAll(this.resolveRef(ref));
                        continue;
                    }
                    if (schema.containsKey("additionalProperties")) {
                        Map additionalProperties = (Map)schema.get("additionalProperties");
                        fields.addAll(this.parseSchema(additionalProperties));
                        continue;
                    }
                    fields.addAll(this.parseSchema(schema));
                }
            }
        }
        return fields;
    }
}

