/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.parsers.model;

import kd.bos.openapi.common.constant.DataType;

public enum IscFieldType {
    INT("int", DataType.INTEGER),
    DECIMAL("decimal", DataType.DECIMAL),
    DATETIME("datetime", DataType.DATE_TIME),
    BOOLEAN("boolean", DataType.BOOLEAN),
    STRING("string", DataType.STRING),
    STRUCT("STRUCT", DataType.STRUCT),
    STRING2("string2", DataType.STRING),
    DOUBLE("double", DataType.DECIMAL),
    DATE("date", DataType.DATE),
    LONG("long", DataType.LONG),
    UNKNOWN("unknown", DataType.ANY),
    IERP_FILE("IERP_FILE", DataType.STRING);

    private final String typeName;
    private final DataType openApiFieldType;

    private IscFieldType(String typeName, DataType openApiFieldType) {
        this.typeName = typeName;
        this.openApiFieldType = openApiFieldType;
    }

    public static IscFieldType getIscTypeByTypeName(String typeName) {
        for (IscFieldType type : IscFieldType.values()) {
            if (!type.typeName.equalsIgnoreCase(typeName)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public DataType getOpenApiFieldType() {
        return this.openApiFieldType;
    }
}

