/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.parsers.xdm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.api.parsers.model.ApiParam;
import kd.isc.iscb.platform.core.api.parsers.xdm.XdmApiParam;
import kd.isc.iscb.platform.core.api.parsers.xdm.XdmConst;

public class ApiParamBuilder
implements XdmConst {
    private String modelString;
    private String exampleString;
    private Map<String, XdmApiParam> originXdmParamMap;

    public ApiParamBuilder(String modelString, String exampleString) {
        this.modelString = modelString;
        this.exampleString = exampleString;
    }

    public List<ApiParam> build() {
        List originXdmParamList = (List)JSON.parseObject((String)this.modelString, (TypeReference)new TypeReference<List<XdmApiParam>>(){}, (Feature[])new Feature[0]);
        this.initOrginXdmParamMap(originXdmParamList);
        return this.buildApiParams(originXdmParamList);
    }

    private List<ApiParam> buildApiParams(List<XdmApiParam> originXdmParamList) {
        ArrayList<ApiParam> params = new ArrayList<ApiParam>(originXdmParamList.size());
        JSONObject example = JSON.parseObject((String)this.exampleString, (Feature[])new Feature[]{Feature.OrderedField});
        for (Map.Entry entry : example.entrySet()) {
            this.addParamToList(params, entry);
        }
        return params;
    }

    private void addParamToList(List<ApiParam> params, Map.Entry<String, Object> entry) {
        String fieldName = entry.getKey();
        Object value = entry.getValue();
        params.add(new ApiParam(this.originXdmParamMap, fieldName, value));
    }

    private void initOrginXdmParamMap(List<XdmApiParam> originXdmParamList) {
        this.originXdmParamMap = new LinkedHashMap<String, XdmApiParam>(originXdmParamList.size());
        for (XdmApiParam originXdmParam : originXdmParamList) {
            this.originXdmParamMap.put(originXdmParam.getName(), originXdmParam);
        }
    }
}

