/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.quick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import kd.bos.dataentity.resource.ResManager;

public class CurlTokenFinder {
    private static final int NORMAL = 0;
    private static final int IN_QUOTE = 1;
    private static final int IN_DOUBLE_QUOTE = 2;
    private static final int ESCAPE = 3;
    private List<String> validStrings = new ArrayList<String>();
    private StringBuilder current = new StringBuilder();
    private int state = 0;
    private boolean lastTokenHasBeenQuoted = false;

    protected CurlTokenFinder(String curlString) {
        StringTokenizer tok = new StringTokenizer(curlString, "\"' ", true);
        while (tok.hasMoreTokens()) {
            this.scanToken(tok);
        }
        if (this.lastTokenHasBeenQuoted || this.current.length() > 0) {
            this.validStrings.add(this.current.toString());
        }
        if (this.state == 1 || this.state == 2) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e0d\u6210\u5bf9\u7684'\u6216\"\u7b26\u53f7%s", (String)"CurlTokenFinder_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), curlString));
        }
    }

    public List<String> find() {
        return Collections.unmodifiableList(this.validStrings);
    }

    private void scanToken(StringTokenizer tok) {
        String nextTok = tok.nextToken();
        switch (this.state) {
            case 1: {
                this.handleQuote(nextTok, "'");
                break;
            }
            case 2: {
                this.handleQuote(nextTok, "\"");
                break;
            }
            case 3: {
                this.handleEscape(nextTok);
                break;
            }
            default: {
                this.defaultHandle(nextTok);
            }
        }
    }

    private void handleEscape(String nextTok) {
        this.current.append('\\').append(nextTok);
        this.state = 0;
    }

    private void handleQuote(String nextTok, String s) {
        if (s.equals(nextTok)) {
            this.lastTokenHasBeenQuoted = true;
            this.state = 0;
        } else {
            this.current.append(nextTok);
        }
    }

    private void defaultHandle(String nextTok) {
        if ("'".equals(nextTok)) {
            this.state = 1;
        } else if ("\"".equals(nextTok)) {
            this.state = 2;
        } else if (" ".equals(nextTok)) {
            if (this.lastTokenHasBeenQuoted || this.current.length() > 0) {
                this.validStrings.add(this.current.toString());
                this.current.setLength(0);
            }
        } else if ("\\".equals(nextTok)) {
            this.state = 3;
        } else {
            this.current.append(nextTok.replaceAll("^\\\\(\\r\\n|\\n)", ""));
        }
        this.lastTokenHasBeenQuoted = false;
    }
}

