/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.webapi.Util;

public enum FormatType {
    JSON{

        @Override
        public String genScript() {
            return ResManager.loadKDString((String)"//\u5c06\u8bf7\u6c42\u4f53\u6570\u636e\u8f6c\u6362\u4e3aJSON\u4e32", (String)"FormatType_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\nvar dataStr = String.FormatJson($body);\n";
        }

        @Override
        public Map<String, Object> parse(String str) {
            return (Map)com.alibaba.fastjson.JSON.parseObject((String)str, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        }

        @Override
        public String genScript(String str) {
            return "String.FormatJson(data)";
        }
    }
    ,
    XML{

        @Override
        public String genScript() {
            return ResManager.loadKDString((String)"//\u5c06\u8bf7\u6c42\u4f53\u6570\u636e\u8f6c\u6362\u4e3aXML\u5b57\u7b26\u4e32", (String)"FormatType_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\nvar dataStr = String(String.json2Xml($body));\n";
        }

        @Override
        public String genScript(String str) {
            return "String(String.json2Xml(data))";
        }

        @Override
        public Map<String, Object> parse(String str) {
            return Util.xmlToMap(str);
        }
    }
    ,
    URLENCODE{

        @Override
        public String genScript() {
            return ResManager.loadKDString((String)"//\u5c06\u8bf7\u6c42\u4f53\u6570\u636e\u8f6c\u6362\u4e3aurlencode\u5b57\u7b26\u4e32", (String)"FormatType_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\nvar dataStr = MapToURLEncodeString($body);\n";
        }

        @Override
        public String genScript(String str) {
            return "MapToURLEncodeString(data)";
        }

        @Override
        public Map<String, Object> parse(String str) {
            return Util.initUrlParamMap(str);
        }
    }
    ,
    TEXT{

        @Override
        public String genScript() {
            return "var dataStr = $body;\n";
        }

        @Override
        public Map<String, Object> parse(String str) {
            return (Map)com.alibaba.fastjson.JSON.parseObject((String)str, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        }

        @Override
        public String genScript(String str) {
            return "String.FormatJson(data)";
        }
    }
    ,
    NONE{

        @Override
        public String genScript() {
            return "var dataStr = null;\n";
        }

        @Override
        public Map<String, Object> parse(String str) {
            return new HashMap<String, Object>();
        }

        @Override
        public String genScript(String str) {
            return "null";
        }
    }
    ,
    DEFAULT{

        @Override
        public String genScript() {
            return "var dataStr = null;\n";
        }

        @Override
        public Map<String, Object> parse(String str) {
            return null;
        }

        @Override
        public String genScript(String str) {
            return "null";
        }
    };


    public abstract String genScript();

    public abstract Map<String, Object> parse(String var1);

    public abstract String genScript(String var1);

    public static FormatType getFormatTypeByContentType(String contentType) {
        if (contentType == null) {
            return DEFAULT;
        }
        if (contentType.contains("json")) {
            return JSON;
        }
        if (contentType.contains("x-www-form-urlencoded")) {
            return URLENCODE;
        }
        if (contentType.contains("xml")) {
            return XML;
        }
        if (contentType.contains("text")) {
            return TEXT;
        }
        if ("none".equalsIgnoreCase(contentType)) {
            return NONE;
        }
        return URLENCODE;
    }
}

