/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.IscScript;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.api.quick.HttpItem;
import kd.isc.iscb.platform.core.api.quick.HttpRecorder;
import kd.isc.iscb.platform.core.api.quick.stub.HttpAccessStub;
import kd.isc.iscb.platform.core.api.quick.stub.HttpGetStub;
import kd.isc.iscb.platform.core.api.quick.stub.HttpInvokeStub;
import kd.isc.iscb.platform.core.api.quick.stub.HttpPostStub;
import kd.isc.iscb.platform.core.api.webapi.Param;
import kd.isc.iscb.platform.core.api.webapi.multipart.stub.HttpToolKitStub;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.WebServiceStub;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.misc.SystemContext;
import kd.isc.iscb.util.script.misc.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Util {
    public static Map<String, Object> evalParam(Map<String, Param> paramMap, Map<String, Object> ctx, boolean omitEmptyParams) {
        if (CollectionUtils.isEmpty(paramMap)) {
            return null;
        }
        Set<Map.Entry<String, Param>> entries = paramMap.entrySet();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(entries.size());
        for (Map.Entry<String, Param> entry : entries) {
            String name = entry.getKey();
            Param param = entry.getValue();
            Object value = param.eval(ctx);
            if (value == null && omitEmptyParams) continue;
            map.put(name, value);
        }
        return map;
    }

    public static Map<String, Object> initUrlParamMap(String urlParamStr) {
        String[] params = urlParamStr.split("&");
        LinkedHashMap<String, Object> queryParamMap = new LinkedHashMap<String, Object>(params.length);
        for (int i = 0; i < params.length; ++i) {
            String param = D.s((Object)params[i]);
            if (param == null) continue;
            int j = param.indexOf("=");
            String key = param.substring(0, j);
            String value = param.substring(j + 1);
            queryParamMap.put(key, value);
        }
        return queryParamMap;
    }

    public static String getContentType(Map<String, Object> webReqHeaders) {
        String contentType = D.s((Object)webReqHeaders.get("Content-Type"));
        if (contentType == null) {
            contentType = D.s((Object)webReqHeaders.get("content-type"));
        }
        if (contentType == null) {
            for (Map.Entry<String, Object> entry : webReqHeaders.entrySet()) {
                String headName = entry.getKey();
                if (!"content-type".equalsIgnoreCase(headName)) continue;
                contentType = D.s((Object)entry.getValue());
                break;
            }
        }
        return contentType;
    }

    public static String getContentTypeByBodyStr(String bodyStr) {
        if (bodyStr == null) {
            return null;
        }
        if (bodyStr.startsWith("{") || bodyStr.startsWith("[")) {
            return "application/json";
        }
        if (bodyStr.startsWith("<?xml")) {
            return "text/xml";
        }
        if (bodyStr.length() == 0 || bodyStr.contains("=")) {
            return "application/x-www-form-urlencoded";
        }
        return null;
    }

    public static String findBoundaryInHeaders(Map<String, Object> webReqHeaders) {
        String contentType = Util.getContentType(webReqHeaders);
        if (contentType != null && contentType.contains("multipart/form-data")) {
            String tag = "boundary=";
            int index = contentType.indexOf(tag);
            if (index > 0) {
                return D.s((Object)contentType.substring(index + tag.length()));
            }
            return null;
        }
        return null;
    }

    public static String generateMultipartContentType(String boundary) {
        String s = boundary != null ? boundary : Util.newBoundary();
        return "multipart/form-data; boundary=" + s;
    }

    public static String newBoundary() {
        return "--------------------ISCB" + Hash.mur32((Object[])new Object[]{UUID.randomUUID()});
    }

    public static Map<String, Object> xmlToMap(String xml) {
        Document doc = Xml.parse((String)xml);
        Element node = doc.getDocumentElement();
        Object wrap = WebServiceStub.wrap((NodeList)node.getChildNodes());
        if (wrap == null) {
            return Collections.emptyMap();
        }
        if (wrap instanceof Map) {
            return (Map)wrap;
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"xml\u7247\u6bb5\u53ea\u652f\u6301\u8fd4\u56demap\u7c7b\u578b\u6570\u636e\uff0c\u5f53\u524d\u8fd4\u56de\u4e86%s", (String)"Util_30", (String)"isc-iscb-platform-core", (Object[])new Object[0]), wrap.getClass()));
    }

    private static Element createRootElement(String rootName) {
        Document doc = Xml.newDocument();
        Element root = doc.createElement(rootName);
        doc.appendChild(root);
        return root;
    }

    public static String encode(String key, Object value) {
        if (value instanceof List) {
            return Util.encodeListValue(key, (List)value);
        }
        return Util.encodeSingleValue(key, value);
    }

    private static String encodeListValue(String key, List<Object> listValue) {
        StringBuilder s = new StringBuilder();
        for (Object v : listValue) {
            if (s.length() > 0) {
                s.append('&');
            }
            s.append(Util.encodeSingleValue(key, v));
        }
        return s.toString();
    }

    private static String encodeSingleValue(String key, Object v) {
        StringBuilder s = new StringBuilder();
        s.append(Util.encodeWhenNotContainPercent(key));
        s.append('=');
        String value = v == null ? "" : v.toString();
        s.append(Util.encodeWhenNotContainPercent(value));
        return s.toString();
    }

    public static String encode(Map<String, Object> data) {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            if (s.length() > 0) {
                s.append('&');
            }
            String key = e.getKey();
            Object v = e.getValue();
            s.append(Util.encode(key, v));
        }
        return s.toString();
    }

    private static String encodeWhenNotContainPercent(String sourceStr) {
        if (sourceStr.contains("%")) {
            return sourceStr;
        }
        return Util.encode(sourceStr);
    }

    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw CommonError.INVALID_CHARSET.create((Throwable)e, new String[]{"UTF-8"});
        }
    }

    public static IscFieldType getIscFieldTypeFromValue(Object object) {
        if (object instanceof Integer) {
            return IscFieldType.INT;
        }
        if (object instanceof Boolean) {
            return IscFieldType.BOOLEAN;
        }
        if (object instanceof String) {
            return IscFieldType.STRING;
        }
        if (object instanceof Long) {
            return IscFieldType.LONG;
        }
        if (object instanceof Double) {
            return IscFieldType.DOUBLE;
        }
        if (object instanceof BigDecimal) {
            return IscFieldType.DECIMAL;
        }
        return IscFieldType.UNKNOWN;
    }

    public static boolean isEmpty(Object val) {
        return val == null || val.toString().length() == 0;
    }

    public static Map<String, Object> getDataMap(String jsonStr) {
        if (jsonStr == null) {
            return null;
        }
        Object o = JSON.parse((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField});
        Map mapValue = null;
        if (o instanceof List) {
            List listValue = (List)o;
            Object firstVal = listValue.get(0);
            if (firstVal instanceof Map) {
                mapValue = (Map)firstVal;
            }
        } else if (o instanceof Map) {
            mapValue = (Map)o;
        }
        return mapValue;
    }

    public static HttpItem generateHttpItemFromIscScript(String scriptText) {
        try {
            Script script;
            HttpRecorder.openRecording();
            try {
                script = IscScript.compile(scriptText, Util.replaceHttpFunction());
            }
            catch (Throwable e) {
                throw new IscBizException(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u96c6\u6210\u811a\u672c\u4e0d\u5408\u6cd5\uff0c\u9519\u8bef\u539f\u56e0\uff1a", (String)"Util_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e);
            }
            script.eval();
            HttpItem httpItem = HttpRecorder.getHttpItem();
            return httpItem;
        }
        finally {
            HttpRecorder.closeRecording();
        }
    }

    public static DynamicObject queryConnTypeByConn(DynamicObject cn) {
        QFilter qFilter = new QFilter("number", "=", (Object)cn.getString("database_type"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"isc_connection_type", (QFilter[])new QFilter[]{qFilter});
    }

    public static HashMap<String, Object> replaceHttpFunction() {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        HttpAccessStub httpAccessStub = new HttpAccessStub();
        HttpGetStub httpGetStub = new HttpGetStub();
        HttpPostStub httpPostStub = new HttpPostStub();
        HttpInvokeStub httpInvokeStub = new HttpInvokeStub();
        ctx.put(httpAccessStub.name(), httpAccessStub);
        ctx.put(httpGetStub.name(), httpGetStub);
        ctx.put(httpPostStub.name(), httpPostStub);
        ctx.put(httpInvokeStub.name(), httpInvokeStub);
        HttpToolKitStub httpToolKitStub = new HttpToolKitStub();
        ctx.put(httpToolKitStub.name(), httpToolKitStub);
        return ctx;
    }

    public static boolean isDebugMode() {
        return SystemContext.isDevEnv() || SystemContext.isTestEnv() || D.x((Object)ContextUtil.getTenantProperty("isc_debug_mode"));
    }
}

