/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.FormatType;
import kd.isc.iscb.platform.core.api.webapi.Param;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class WebReqHeader
implements Const {
    private Map<String, Param> nameToParam = new LinkedHashMap<String, Param>();

    public WebReqHeader(DynamicObjectCollection reqHeaderEntries) {
        for (DynamicObject headEntry : reqHeaderEntries) {
            long id = D.l((Object)headEntry.get("id"));
            String name = D.s((Object)headEntry.get("req_h_param_name"));
            String desc = D.s((Object)headEntry.get("req_h_param_desc"));
            String value = D.s((Object)headEntry.get("req_h_param_value"));
            String type = D.s((Object)headEntry.get("req_h_param_type"));
            boolean required = D.x((Object)headEntry.get("req_h_param_required"));
            Param param = new Param(id, name, desc, type, false, required, null, value);
            this.nameToParam.put(name, param);
        }
    }

    public Map<String, Object> getExampleParamMap() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        if (!this.nameToParam.isEmpty()) {
            for (Map.Entry<String, Param> entry : this.nameToParam.entrySet()) {
                String filedName = entry.getKey();
                Param param = entry.getValue();
                String paramValue = param.getParamValue();
                if (paramValue == null) continue;
                ret.put(filedName, paramValue);
            }
        }
        return ret;
    }

    public Map<String, Object> getExampleXParamMap() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        if (!this.nameToParam.isEmpty()) {
            for (Map.Entry<String, Param> entry : this.nameToParam.entrySet()) {
                String filedName = entry.getKey();
                Param param = entry.getValue();
                String paramValue = param.getParamValue();
                if (paramValue != null) continue;
                ret.put(filedName, param.getTestValue());
            }
        }
        return ret;
    }

    public String getHeaderString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Param> e : this.nameToParam.entrySet()) {
            if (sb.length() > 0) {
                sb.append(",\n");
            }
            String fieldName = e.getKey();
            sb.append("    \"").append(fieldName).append('\"').append(':');
            Param param = e.getValue();
            String paramValue = param.getParamValue();
            if (paramValue == null) {
                sb.append("$head.").append('\"').append(fieldName).append('\"');
                continue;
            }
            if (paramValue.startsWith("$")) {
                sb.append(paramValue);
                continue;
            }
            if (paramValue.startsWith("<%") && paramValue.endsWith("%>")) {
                sb.append("$head.").append('\"').append(fieldName).append('\"');
                continue;
            }
            sb.append(JSON.toJSONString((Object)paramValue));
        }
        return sb.toString();
    }

    public FormatType getFormatType(String contentType) {
        return FormatType.getFormatTypeByContentType(contentType);
    }

    public Map<String, Object> eval(Map<String, Object> ctx) {
        try {
            return Util.evalParam(this.nameToParam, ctx, false);
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u53c2\u6570\u8f6c\u6362\u51fa\u9519\uff1a", (String)"WebReqHeader_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public Map<String, Param> getNameToParam() {
        return Collections.unmodifiableMap(this.nameToParam);
    }
}

