/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.Param;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.util.dt.D;

public class WebRespBody
implements Const {
    private Map<String, Param> nameToParam = new LinkedHashMap<String, Param>();

    public WebRespBody(DynamicObjectCollection webRespBody) {
        HashMap<Long, Param> idToParam = new HashMap<Long, Param>(8);
        for (DynamicObject bodyEntry : webRespBody) {
            long id = D.l((Object)bodyEntry.get("id"));
            long pid = D.l((Object)bodyEntry.get("pid"));
            String name = D.s((Object)bodyEntry.get("resp_b_param_name"));
            String desc = D.s((Object)bodyEntry.get("resp_b_param_desc"));
            String value = D.s((Object)bodyEntry.get("resp_b_param_value"));
            String type = D.s((Object)bodyEntry.get("resp_b_param_type"));
            boolean isArray = D.x((Object)bodyEntry.get("resp_b_param_is_array"));
            boolean required = D.x((Object)bodyEntry.get("resp_b_param_required"));
            String exampleValue = D.s((Object)bodyEntry.get("resp_b_param_example"));
            Param param = new Param(id, name, desc, type, isArray, required, exampleValue, value);
            if (pid > 0L) {
                Param parentParam = (Param)idToParam.get(pid);
                parentParam.addChildParam(param);
            } else {
                this.nameToParam.put(name, param);
            }
            idToParam.put(id, param);
        }
    }

    public Object eval(Object result) {
        if (result == null) {
            return null;
        }
        if (result instanceof Map) {
            return Util.evalParam(this.nameToParam, (Map)result, false);
        }
        if (result instanceof String) {
            return this.handleString(result);
        }
        return result;
    }

    private Object handleString(Object result) {
        String resultStr = D.s((Object)result);
        if (JSON.isValidObject((String)resultStr)) {
            JSONObject jsonObject = JSON.parseObject((String)resultStr, (Feature[])new Feature[]{Feature.OrderedField});
            return Util.evalParam(this.nameToParam, (Map<String, Object>)jsonObject, false);
        }
        return result;
    }

    public Map<String, Object> getExampleParamMap() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        if (!this.nameToParam.isEmpty()) {
            for (Map.Entry<String, Param> entry : this.nameToParam.entrySet()) {
                String filedName = entry.getKey();
                Param param = entry.getValue();
                if (param.getParamValue() != null) continue;
                ret.put(filedName, param.getTestValue());
            }
        }
        return ret;
    }

    public Map<String, Param> getNameToParam() {
        return Collections.unmodifiableMap(this.nameToParam);
    }
}

