/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi.multipart;

import java.io.IOException;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.f.DataFileUtils;
import kd.isc.iscb.util.except.IscBizException;

public class CalcSizeOutputStream
extends OutputStream {
    private OutputStream out;
    private long size;
    private long maxSize = DataFileUtils.getMaxDataSize();

    public CalcSizeOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.checkMaxSize(1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.checkMaxSize(b.length);
    }

    private void checkMaxSize(int length) {
        this.size += (long)length;
        if (this.size > this.maxSize) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u62a5\u6587\u7684\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff08%s\u5b57\u8282\uff09\uff0c\u6b64\u63aa\u65bd\u662f\u4e3a\u4e86\u9650\u5236\u62a5\u6587\u5927\u5c0f\u4ee5\u964d\u4f4e\u7cfb\u7edfOOM\u7684\u98ce\u9669\u3002\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u8c03\u6574\u4e1a\u52a1\u5904\u7406\u907f\u514d\u53d1\u9001\u8d85\u5927\u62a5\u6587\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574JVM\u7cfb\u7edf\u53c2\u6570 ISC_MAX_DATA_SIZE \uff08\u5355\u4f4d\uff1a\u5b57\u8282\uff09\u63d0\u9ad8\u4e0a\u9650\u3002", (String)"CalcSizeOutputStream_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.maxSize));
        }
    }
}

