/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi.multipart;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileServiceFactory;
import kd.isc.iscb.platform.core.dc.f.DataFileUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class IerpFileContent {
    private String fileUrl;
    private String fileName;
    private long maxFileSize = DataFileUtils.getMaxFileSize();

    public IerpFileContent(String fileUrl) {
        this.fileUrl = fileUrl;
        this.fileName = this.getFileName(fileUrl);
    }

    public String getFileName() {
        return this.fileName;
    }

    private InputStream getInputStream() {
        boolean exists = FileServiceFactory.getAttachmentFileService().exists(this.fileUrl);
        if (!exists) {
            throw new IscBizException(this.getErrorMsg());
        }
        try {
            return FileServiceFactory.getAttachmentFileService().getInputStream(this.fileUrl);
        }
        catch (Throwable e) {
            throw new IscBizException(this.getErrorMsg(), e);
        }
    }

    private String getErrorMsg() {
        String formatStr = ResManager.loadKDString((String)"\u83b7\u53d6\u82cd\u7a79\u9644\u4ef6\u6d41\u5931\u8d25\uff0cURL\uff1a%1$s", (String)"IerpFileContent_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        return String.format(formatStr, this.fileUrl);
    }

    public void writeToOutput(OutputStream out) {
        try (BufferedInputStream in = new BufferedInputStream(this.getInputStream());){
            this.copyStream(in, out);
        }
        catch (IOException e) {
            throw D.e((Throwable)e);
        }
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        int count = 0;
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
            if ((long)(count += len) <= this.maxFileSize) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5355\u4e2a\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff08%s\u5b57\u8282\uff09\uff0c\u6b64\u63aa\u65bd\u662f\u4e3a\u4e86\u9650\u5236\u6587\u4ef6\u5927\u5c0f\u4ee5\u964d\u4f4e\u7cfb\u7edfOOM\u7684\u98ce\u9669\u3002\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u8c03\u6574\u4e1a\u52a1\u5904\u7406\u907f\u514d\u8bfb\u53d6\u8d85\u5927\u6587\u4ef6\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574JVM\u7cfb\u7edf\u53c2\u6570 ISC_MAX_FILE_SIZE \uff08\u5355\u4f4d\uff1a\u5b57\u8282\uff09\u63d0\u9ad8\u4e0a\u9650\u3002", (String)"IerpFileContent_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.maxFileSize));
        }
    }

    private String getFileName(String fileUrl) {
        String s = D.s((Object)fileUrl);
        if (s == null) {
            throw new UnsupportedOperationException("ierp file url cannot be null");
        }
        int length = fileUrl.length();
        if (IerpFileContent.isFileSeparator(fileUrl.charAt(length - 1))) {
            --length;
        }
        int begin = this.findFileNameBegin(fileUrl, length);
        return fileUrl.substring(begin, length);
    }

    private int findFileNameBegin(String fileUrl, int length) {
        int begin = 0;
        for (int i = length - 1; i > -1; --i) {
            char c = fileUrl.charAt(i);
            if (!IerpFileContent.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return begin;
    }

    private static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }
}

