/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import kd.isc.iscb.platform.core.api.webapi.multipart.MultipartOutputStream;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class MultipartBody {
    private final Map<String, Object> form;
    private final String charset;
    private final String boundary;

    public MultipartBody(Map<String, Object> form, String charset, String boundary) {
        this.form = form;
        this.charset = charset;
        this.boundary = boundary;
    }

    public void write(OutputStream out) {
        try (MultipartOutputStream stream = new MultipartOutputStream(out, this.charset, this.boundary);){
            if (this.form != null && this.form.size() > 0) {
                for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                    String fieldName = entry.getKey();
                    Object value = entry.getValue();
                    stream.write(fieldName, D.s((Object)value));
                }
            }
        }
        catch (IOException e) {
            throw D.e((Throwable)e);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            DbUtil.close((OutputStream)out);
        }
    }

    public String toString() {
        try {
            return new String(this.toByteArray(), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw D.e((Throwable)e);
        }
    }
}

