/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.quick.FormItem;
import kd.isc.iscb.platform.core.api.webapi.multipart.CalcSizeOutputStream;
import kd.isc.iscb.platform.core.api.webapi.multipart.IerpFileContent;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class MultipartOutputStream
extends OutputStream {
    private final OutputStream out;
    private final String charset;
    private final String boundary;
    private static final String CRLF = "\r\n";
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"%s\"\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\nContent-Type: application/octet-stream\r\n";

    public MultipartOutputStream(OutputStream out, String charset, String boundary) {
        this.out = new CalcSizeOutputStream(out);
        this.charset = charset;
        this.boundary = boundary;
    }

    public void write(String fieldName, String value) {
        try {
            this.innerWrite(fieldName, value);
        }
        catch (Exception e) {
            String formatStr = ResManager.loadKDString((String)"\u5904\u7406multipart body\u5b57\u6bb5\u3010%1$s\u3011\u51fa\u9519\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"MultipartOutputStream_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            String message = String.format(formatStr, fieldName);
            throw new IscBizException(message, (Throwable)e);
        }
    }

    private void innerWrite(String fieldName, String value) {
        this.writeBeginLine();
        FormItem formItem = new FormItem(fieldName, value);
        if (formItem.isFile()) {
            this.wrtieIerpFileContent(fieldName, new IerpFileContent(formItem.getFilePath()));
        } else {
            this.writeStringValue(fieldName, value);
        }
        this.write(CRLF);
    }

    private void wrtieIerpFileContent(String fieldName, IerpFileContent fileContent) {
        this.write(String.format(CONTENT_DISPOSITION_FILE_TEMPLATE, fieldName, fileContent.getFileName()));
        this.write(CRLF);
        fileContent.writeToOutput(this);
    }

    private void writeStringValue(String fieldName, Object value) {
        this.write(String.format(CONTENT_DISPOSITION_TEMPLATE, fieldName));
        this.write(CRLF);
        String s = value != null ? value.toString() : "";
        this.write(s);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    private void writeBeginLine() {
        this.write("--", this.boundary, CRLF);
    }

    public void write(String ... strs) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(this.out, this.charset);
            for (String str : strs) {
                if (str == null) continue;
                osw.write(str);
            }
            osw.flush();
        }
        catch (IOException e) {
            throw D.e((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.write("--", this.boundary, "--\r\n");
        DbUtil.close((OutputStream)this.out);
    }
}

