/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.wsdl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.isc.iscb.platform.core.api.wsdl.WsdlOperation;
import kd.isc.iscb.platform.core.api.wsdl.WsdlParameter;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.ws.commons.schema.XmlSchemaElement;

public class WsdlDefinition {
    private static final String OUT = "out";
    private static final String IN = "in";
    private Map<String, WsdlOperation> operationInfoMap = new LinkedHashMap<String, WsdlOperation>();

    public Map<String, WsdlOperation> getOperationInfoMap() {
        return Collections.unmodifiableMap(this.operationInfoMap);
    }

    public WsdlDefinition(AxisService axisService) {
        String targetNamespace = axisService.getTargetNamespace();
        Iterator opsIter = axisService.getOperations();
        while (opsIter.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)opsIter.next();
            WsdlParameter inputParam = null;
            WsdlParameter outParam = null;
            Iterator msgIter = axisOperation.getMessages();
            while (msgIter.hasNext()) {
                AxisMessage axisMessage = (AxisMessage)msgIter.next();
                XmlSchemaElement xmlSchemaElement = axisMessage.getSchemaElement();
                if (IN.equals(axisMessage.getDirection())) {
                    inputParam = new WsdlParameter(xmlSchemaElement);
                    continue;
                }
                if (!OUT.equals(axisMessage.getDirection())) continue;
                outParam = new WsdlParameter(xmlSchemaElement);
            }
            WsdlOperation wsdlOperation = new WsdlOperation(axisOperation.getName().getLocalPart(), targetNamespace, inputParam, outParam);
            this.operationInfoMap.put(wsdlOperation.getName(), wsdlOperation);
        }
    }
}

