/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.wsdl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAllMember;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAnnotationItem;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaDocumentation;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsdlParameter {
    private String name;
    private String desc;
    private String originType;
    private boolean isArray;
    private boolean isNullable;
    private boolean isComplex;
    private List<WsdlParameter> childParams;

    public WsdlParameter() {
    }

    public WsdlParameter(XmlSchemaElement schemaElement) {
        this.name = schemaElement.getName();
        XmlSchemaType schemaType = schemaElement.getSchemaType();
        this.originType = schemaType.getName();
        this.isNullable = schemaElement.isNillable() || schemaElement.getMinOccurs() <= 0L;
        boolean bl = this.isArray = schemaElement.getMaxOccurs() > 1L;
        if (schemaType instanceof XmlSchemaComplexType) {
            this.isComplex = true;
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
            this.desc = this.getDescFromAnnotation(complexType.getAnnotation());
            this.childParams = this.initChildParams(complexType);
        } else {
            this.desc = this.getDescFromAnnotation(schemaElement.getAnnotation());
        }
    }

    private List<WsdlParameter> initChildParams(XmlSchemaComplexType complexType) {
        XmlSchemaParticle particle = complexType.getParticle();
        if (particle == null) {
            XmlSchemaContentModel contentModel = complexType.getContentModel();
            return this.getParametersFromModel(contentModel);
        }
        return this.getParametersFromParticle(particle);
    }

    private List<WsdlParameter> getParametersFromModel(XmlSchemaContentModel contentModel) {
        if (contentModel != null) {
            XmlSchemaContent content = contentModel.getContent();
            if (content instanceof XmlSchemaComplexContentExtension) {
                XmlSchemaComplexContentExtension extContent = (XmlSchemaComplexContentExtension)content;
                return this.getParametersFromParticle(extContent.getParticle());
            }
            return null;
        }
        return null;
    }

    private List<WsdlParameter> getParametersFromParticle(XmlSchemaParticle particle) {
        if (particle instanceof XmlSchemaElement) {
            XmlSchemaElement xmlschema = (XmlSchemaElement)particle;
            ArrayList<WsdlParameter> childParams = new ArrayList<WsdlParameter>(1);
            childParams.add(new WsdlParameter(xmlschema));
            return childParams;
        }
        if (particle instanceof XmlSchemaSequence) {
            List<WsdlParameter> childParams = this.initChildParamsBySeqPart((XmlSchemaSequence)particle);
            return childParams;
        }
        if (particle instanceof XmlSchemaAll) {
            return this.initChildParamsBySchemaAllType((XmlSchemaAll)particle);
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684schema\u7c7b\u578b\uff1a%s", (String)"WsdlParameter_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), particle.getClass()));
    }

    private List<WsdlParameter> initChildParamsBySchemaAllType(XmlSchemaAll xmlSchemaAll) {
        List items = xmlSchemaAll.getItems();
        ArrayList<WsdlParameter> childParams = new ArrayList<WsdlParameter>(items.size());
        for (XmlSchemaAllMember item : items) {
            if (item instanceof XmlSchemaElement) {
                childParams.add(new WsdlParameter((XmlSchemaElement)item));
                continue;
            }
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684XmlSchemaAll\u5b50\u6210\u5458\u7c7b\u578b\uff1a%s", (String)"WsdlParameter_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), item.getClass()));
        }
        return childParams;
    }

    private List<WsdlParameter> initChildParamsBySeqPart(XmlSchemaSequence particle) {
        XmlSchemaSequence schemaSequence = particle;
        List items = schemaSequence.getItems();
        ArrayList<WsdlParameter> childParams = new ArrayList<WsdlParameter>(items.size());
        for (XmlSchemaSequenceMember item : items) {
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement xmlschema = (XmlSchemaElement)item;
                if (xmlschema.getSchemaType() == null) continue;
                childParams.add(new WsdlParameter(xmlschema));
                continue;
            }
            if (!(item instanceof XmlSchemaSequence)) continue;
            List<WsdlParameter> list = this.initChildParamsBySeqPart((XmlSchemaSequence)item);
            childParams.addAll(list);
        }
        return childParams;
    }

    private String getDescFromAnnotation(XmlSchemaAnnotation annotation) {
        if (annotation != null) {
            List items = annotation.getItems();
            for (XmlSchemaAnnotationItem item : items) {
                if (!(item instanceof XmlSchemaDocumentation)) continue;
                XmlSchemaDocumentation doc = (XmlSchemaDocumentation)item;
                NodeList markup = doc.getMarkup();
                Node node = markup.item(0);
                return node.getTextContent();
            }
        }
        return this.name;
    }

    public IscFieldType getIscFieldType() {
        if (this.isComplex) {
            return IscFieldType.STRUCT;
        }
        return IscFieldType.getIscTypeByTypeName(this.originType);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public void setArray(boolean array) {
        this.isArray = array;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public void setComplex(boolean complex) {
        this.isComplex = complex;
    }

    public void setChildParams(List<WsdlParameter> childParams) {
        this.childParams = childParams;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getOriginType() {
        return this.originType;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public List<WsdlParameter> getChildParams() {
        return this.childParams;
    }
}

