/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apic;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.api.CheckApiParamUtil;
import kd.isc.iscb.platform.core.apic.IscApiMeta;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.ServiceUtil;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.util.dt.D;

public class ExternalApiMeta
extends IscApiMeta {
    private String service;
    private Long dataSourceId;
    private IscApiParam inputs;
    private IscApiParam outputs;

    private ExternalApiMeta(DynamicObject cfg) {
        super(cfg);
        this.service = D.s((Object)cfg.get("service"));
        this.dataSourceId = cfg.getLong("group_id");
        this.inputs = IscApicUtil.getInputSchema(cfg);
        this.outputs = IscApicUtil.getOutputSchema(cfg);
    }

    public Long getDataSourceId() {
        return this.dataSourceId;
    }

    public String getService() {
        return this.service;
    }

    public static ExternalApiMeta get(long id) {
        return CacheableObjectManager.get(ExternalApiMeta.class, id);
    }

    public static ExternalApiMeta getByNumber(String number) {
        return CacheableObjectManager.getByNumber(ExternalApiMeta.class, number);
    }

    @Override
    public IscApiParam getInputs() {
        return this.inputs;
    }

    @Override
    public IscApiParam getOutputs() {
        return this.outputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Map<String, Object> params) {
        if (!CheckApiParamUtil.notCheck(this.getDynamicObject(), params)) {
            this.getInputs().narrow(params);
        }
        DynamicObject cfg = this.getDynamicObject();
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(cfg));
        try {
            ConnectionWrapper cn = DataSourceResource.getConnection(this.dataSourceId);
            Object object = ServiceUtil.innerCallService(cn, this.service, params, null);
            return object;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    static {
        CacheableObjectManager.registerFactory(new CacheableObjectFactory<ExternalApiMeta>(){

            @Override
            public String entityType() {
                return "isc_apic_for_external_api";
            }

            @Override
            public ExternalApiMeta create(DynamicObject cfg) {
                return new ExternalApiMeta(cfg);
            }

            @Override
            public Class<ExternalApiMeta> target() {
                return ExternalApiMeta.class;
            }
        });
    }
}

