/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apic;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.api.AbstractApiDispatcher;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.apic.IscApiCaller;
import kd.isc.iscb.platform.core.apic.IscApiMeta;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.apic.IscApiSetting;
import kd.isc.iscb.platform.core.apic.IscLogFactory;
import kd.isc.iscb.platform.core.apis.ApiInvokeStat;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.dc.mq.MQUtil;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.parser.ResourceCategory;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceManager;
import kd.isc.iscb.util.trace.TraceTask;

public class IscApicUtil {
    private static Log logger = LogFactory.getLog(IscApicUtil.class);
    private static final String FIELD_CALLER = "caller";

    public static Object invoke(IscApiMeta schema, Object[] args, String caller) {
        Map<String, Object> params = IscApicUtil.prepareParams(schema, args);
        return IscApicUtil.invoke(schema, params, caller);
    }

    public static Object invoke(IscApiMeta schema, Map<String, Object> params, String caller) {
        IscApicUtil.setDefaultValue(schema.getInputs(), params, schema.shouldOmitEmptyParams());
        DynamicObject log = IscApicUtil.invokeBegin(schema, caller, params);
        try {
            Object result = IscApicUtil.invokeWithTrace(caller, schema, params, log);
            IscApicUtil.invokeEnd(log, AbstractApiDispatcher.resultToMap(schema, result), schema.getDynamicObject());
            return result;
        }
        catch (Throwable e) {
            IscApicUtil.invokeEnd(log, e, schema.getDynamicObject());
            throw e;
        }
    }

    private static Object invokeWithTrace(final String caller, final IscApiMeta schema, final Map<String, Object> params, DynamicObject log) {
        Object result = log == null ? TraceStack.run(TraceType.EXE_APIF, schema.getType() + "/" + schema.getNumber(), schema.getId(), new TraceTask(){

            public Object invoke() {
                return IscApicUtil.invokeApi(caller, schema, params);
            }
        }) : TraceStack.run(TraceType.EXE_APIL, log.getString("params"), log.getLong("id"), new TraceTask(){

            public Object invoke() {
                return IscApicUtil.invokeApi(caller, schema, params);
            }
        });
        return result;
    }

    private static Object invokeApi(String caller, IscApiMeta schema, Map<String, Object> params) {
        IscApicUtil.checkDisableTrace(schema);
        IscApicUtil.checkEnable(schema);
        IscApicUtil.checkCaller(schema, caller);
        Object result = IscApicUtil.invokeApi(schema, params);
        return result;
    }

    private static void checkDisableTrace(IscApiMeta schema) {
        if (schema.isDisableTrace()) {
            TraceManager.disableTrace();
        }
    }

    private static void checkEnable(IscApiMeta schema) {
        if (!schema.isEnabled() && AppParameterServiceHelper.isEnableControl()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a:%s\u7684API\u672a\u542f\u7528.", (String)"IscApicUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), schema.getNumber()));
        }
    }

    private static Object invokeApi(IscApiMeta schema, Map<String, Object> params) {
        try {
            return schema.invoke(params);
        }
        catch (Throwable e) {
            throw ApicError.API_INVOCATION_FAILED.create(e, new String[]{schema.getNumber(), schema.getType(), StringUtil.getCascadeMessage((Throwable)e)});
        }
    }

    private static void setDefaultValue(IscApiParam schema, Map<String, Object> params, boolean shouldOmitEmptyParams) {
        int j = schema.fieldCount();
        for (int i = 0; i < j; ++i) {
            IscApiParam.Field f = schema.getField(i);
            Object value = params.get(f.getName());
            if (value == null) {
                value = f.getDefaultValue();
                params.put(f.getName(), value);
            }
            if (f.getSchema() != null) {
                IscApicUtil.setDefaultValue(f, value, shouldOmitEmptyParams);
            }
            if (!shouldOmitEmptyParams || value != null && !"".equals(value)) continue;
            params.remove(f.getName());
        }
    }

    private static void setDefaultValue(IscApiParam.Field f, Object value, boolean shouldOmitEmptyParams) {
        if (value instanceof Map) {
            IscApicUtil.setDefaultValue(f.getSchema(), (Map)value, shouldOmitEmptyParams);
        } else if (value instanceof Collection) {
            IscApicUtil.setDefaultValue(f, (Collection)value, shouldOmitEmptyParams);
        }
    }

    private static void setDefaultValue(IscApiParam.Field f, Collection<?> items, boolean shouldOmitEmptyParams) {
        for (Object item : items) {
            if (!(item instanceof Map)) continue;
            IscApicUtil.setDefaultValue(f.getSchema(), (Map)item, shouldOmitEmptyParams);
        }
    }

    private static Map<String, Object> prepareParams(IscApiMeta schema, Object[] args) {
        IscApiParam inputs = schema.getInputs();
        IscApicUtil.checkArgs(inputs, args);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(args.length);
        for (int i = 0; i < args.length; ++i) {
            String key = inputs.getField(i).getName();
            params.put(key, args[i]);
        }
        return params;
    }

    private static void checkArgs(IscApiParam inputs, Object[] args) {
        if (inputs.fieldCount() != args.length) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u63d0\u4f9b\u7684\u53c2\u6570\u4e2a\u6570\u4e0e\u5b9a\u4e49\u4e0d\u7b26\uff0c\u8981\u6c42%1$s\u4e2a\uff0c\u5b9e\u9645\u63d0\u4f9b%2$s\u4e2a\uff01", (String)"IscApicUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), inputs.fieldCount(), args.length));
        }
    }

    private static void checkCaller(IscApiMeta api, String caller) {
        if (!api.isAuthRequired()) {
            return;
        }
        IscApiCaller callerInfo = IscApicUtil.findCaller(api.getNumber(), api.getType(), caller);
        QFilter filter = new QFilter("type", "=", (Object)api.getType()).and("api", "=", (Object)api.getId()).and(FIELD_CALLER, "=", (Object)callerInfo.getId());
        if (!QueryServiceHelper.exists((String)"isc_apic_permission", (QFilter[])new QFilter[]{filter})) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u8005\uff08%1$s\uff09\u6ca1\u6709API\u6388\u6743\u3002\u88ab\u8c03\u7528\u7684API\u662f\uff1a%2$s(%3$s)", (String)"IscApicUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), caller, api.getNumber(), api.getType()));
        }
    }

    private static IscApiCaller findCaller(String apiNumber, String apiType, String caller) {
        IscApiCaller callerInfo = IscApiCaller.get(caller);
        if (callerInfo == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u8005\u6807\u8bc6\uff08%1$s\uff09\u672a\u6ce8\u518c\uff01\u88ab\u8c03\u7528\u7684API\u662f\uff1a%2$s(%3$s)", (String)"IscApicUtil_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), caller, apiNumber, apiType));
        }
        return callerInfo;
    }

    public static void checkCaller(DynamicObject object, String type, String caller) {
        if (!D.x((Object)object.get("auth_required"))) {
            return;
        }
        IscApiCaller callerInfo = IscApicUtil.findCaller(object.getString("number"), type, caller);
        QFilter filter = new QFilter("type", "=", (Object)type).and("api", "=", object.get("id")).and(FIELD_CALLER, "=", (Object)callerInfo.getId());
        if (!QueryServiceHelper.exists((String)"isc_apic_permission", (QFilter[])new QFilter[]{filter})) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u8005\uff08%1$s\uff09\u6ca1\u6709API\u6388\u6743\u3002\u88ab\u8c03\u7528\u7684API\u662f\uff1a%2$s(%3$s)", (String)"IscApicUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), caller, object.get("number"), type));
        }
    }

    private static DynamicObject invokeBegin(IscApiMeta api, String caller, Object params) {
        if (!api.isRecordLog()) {
            return null;
        }
        String apiType = api.getType();
        return IscApicUtil.loggerBegin(apiType, api.getDynamicObject(), caller, params);
    }

    public static DynamicObject invokeBegin(DynamicObject apiObj, String apiType, String caller, Object params) {
        if (!apiObj.getBoolean("record_log")) {
            return null;
        }
        DynamicObject log = IscApicUtil.loggerBegin(apiType, apiObj, caller, params);
        return log;
    }

    private static DynamicObject loggerBegin(String apiType, DynamicObject apiObj, String caller, Object params) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_apic_log");
        log.set("id", (Object)IDService.get().genLongId());
        log.set("type", (Object)apiType);
        log.set("api", (Object)apiObj.getLong("id"));
        log.set("start_time", (Object)new Timestamp(System.currentTimeMillis()));
        log.set("state", (Object)"R");
        String s = Json.toString((Object)params);
        log.set("params", MQUtil.parseMsgDigest(s, D.s((Object)apiObj.get("in_digest"))));
        log.set("params_tag", (Object)StringUtil.trim((String)s, (int)IscApiSetting.getApiLogParamSize()));
        log.set("server", (Object)StringUtil.trim((String)NetUtil.getServerId(), (int)100));
        log.set(FIELD_CALLER, (Object)StringUtil.trim((String)caller, (int)50));
        IscLogFactory.getLogService().saveLog(log);
        return log;
    }

    public static void invokeEnd(DynamicObject log, Object result, DynamicObject apiObj) {
        IscApicUtil.refreshCounter(result);
        if (log != null) {
            IscLogFactory.getLogService().updateLog(log, result, apiObj);
        }
        IscApicUtil.refreshInvokeStat(apiObj, result);
    }

    private static void refreshInvokeStat(DynamicObject apiObj, Object result) {
        boolean failed = result instanceof Throwable;
        ApiInvokeStat.createOrUpdateInvokeStat(apiObj, failed);
    }

    private static void refreshCounter(Object result) {
        IscRuntimeInfo info = IscRuntimeInfo.get();
        if (result instanceof Throwable) {
            info.incApiFailedCount();
        }
        info.incApiTotalCount();
    }

    public static IscApiParam getOutputSchema(DynamicObject cfg) {
        DynamicObjectCollection c = cfg.getDynamicObjectCollection("outputs");
        ArrayList<IscApiParam.Field> fields = new ArrayList<IscApiParam.Field>(c.size());
        for (DynamicObject p : c) {
            String name = p.getString("output_field");
            String dataType = p.getString("output_data_type");
            String title = p.getString("output_description");
            boolean is_array = p.getBoolean("output_is_array");
            fields.add(new IscApiParam.Field(name, dataType, title, is_array, false, null));
        }
        IscApiParam inputs = new IscApiParam(fields);
        return inputs;
    }

    public static IscApiParam getInputSchema(DynamicObject cfg) {
        DynamicObjectCollection c = cfg.getDynamicObjectCollection("inputs");
        ArrayList<IscApiParam.Field> fields = new ArrayList<IscApiParam.Field>(c.size());
        for (DynamicObject p : c) {
            String name = p.getString("input_field");
            String dataType = p.getString("input_data_type");
            boolean is_array = p.getBoolean("input_is_array");
            String title = p.getString("input_description");
            boolean required = p.getBoolean("required");
            String defaultValue = p.getString("default_value");
            fields.add(new IscApiParam.Field(name, dataType, title, is_array, required, defaultValue));
        }
        IscApiParam inputs = new IscApiParam(fields);
        return inputs;
    }

    static Map<String, Object> getResource(DynamicObject cfg) {
        DynamicObjectCollection items = cfg.getDynamicObjectCollection("resources");
        LinkedHashMap<String, Object> resources = new LinkedHashMap<String, Object>(items.size() + 10);
        for (DynamicObject item : items) {
            DynamicObject ref = item.getDynamicObject("res_ref");
            String s = ((String)item.get("res_category")).toUpperCase();
            ResourceCategory category = ResourceCategory.valueOf(s);
            Resource res = IscApicUtil.create(ref, category);
            String alias = D.s((Object)item.getString("res_alias"));
            resources.put(alias, res);
        }
        return resources;
    }

    private static Resource create(DynamicObject ref, ResourceCategory category) {
        long id = ref.getLong("id");
        String name = ref.getString("number");
        String title = ref.getString("name");
        Resource res = category.create(id, name, title);
        return res;
    }
}

