/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.app;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class AppParameterServiceHelper {
    private static final String T_ISC_APP_PARAMS = "T_ISC_APP_PARAMS";
    private static final String APPID = "TV3/VDJ86RC";
    private static Log logger = LogFactory.getLog(AppParameterServiceHelper.class);

    public static Map<String, Object> getAllParameters() {
        Map<String, Object> result = AppParameterServiceHelper.loadFromDB();
        AppParameterServiceHelper.putAppParametersToCache(result);
        return result;
    }

    private static Map<String, Object> loadFromDB() {
        return (Map)DB.query((DBRoute)DBRoute.of((String)"ISCB"), (String)"SELECT FID, FVALUE FROM T_ISC_APP_PARAMS", null, rs -> {
            HashMap<String, String> params = new HashMap<String, String>(16);
            while (rs.next()) {
                params.put(rs.getString(1), rs.getString(2));
            }
            return params;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putAppParameters(Map<String, Object> params) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                AppParameterServiceHelper.updateRecord(cn, entry.getKey(), entry.getValue());
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        AppParameterServiceHelper.clearCache();
    }

    public static void putAppParameter(String key, String value) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            AppParameterServiceHelper.updateRecord(cn, key, value);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        AppParameterServiceHelper.clearCache();
    }

    private static void clearCache() {
        LocalMemoryCache cache = AppParameterServiceHelper.getLocalCache(RequestContext.get().getAccountId());
        cache.clear();
    }

    public static void removeAppParameter(String key) {
        DB.execute((DBRoute)DBRoute.of((String)"ISCB"), (String)"DELETE FROM T_ISC_APP_PARAMS WHERE FID = ?", (Object[])new String[]{key});
        AppParameterServiceHelper.clearCache();
    }

    private static void updateRecord(Connection cn, String id, Object value) {
        Assert.isTrue((id != null && value != null ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u914d\u7f6e\u5b57\u6bb5\u548c\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AppParameterServiceHelper_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Object count = DbUtil.executeScalar((Connection)cn, (String)"SELECT count(*) FROM T_ISC_APP_PARAMS WHERE FID = ?", Collections.singletonList(id), Collections.singletonList(12));
        if (D.l((Object)count) == 0L) {
            List<Object> values = Arrays.asList(id, D.s((Object)value), D.l((Object)RequestContext.get().getUserId()), D.t((Object)System.currentTimeMillis()));
            List<Integer> types = Arrays.asList(12, 12, -5, 93);
            DbUtil.executeUpdate((Connection)cn, (String)"INSERT INTO T_ISC_APP_PARAMS (FID, FVALUE, FMODIFIER, FMODIFIED_TIME) VALUES(?,?,?,?)", values, types);
        } else {
            List<Object> values = Arrays.asList(D.s((Object)value), D.l((Object)RequestContext.get().getUserId()), D.t((Object)System.currentTimeMillis()), id);
            List<Integer> types = Arrays.asList(12, -5, 93, 12);
            DbUtil.executeUpdate((Connection)cn, (String)"UPDATE T_ISC_APP_PARAMS SET FVALUE = ?, FMODIFIER =?, FMODIFIED_TIME = ? where FID = ?", values, types);
        }
    }

    public static Object getParameterFromCache(String key) {
        LocalMemoryCache cache = AppParameterServiceHelper.getLocalCache(RequestContext.get().getAccountId());
        Object data = cache.get(APPID);
        if (data == null) {
            Map<String, Object> params = AppParameterServiceHelper.loadFromDB();
            cache.put(APPID, params);
            return params.get(key);
        }
        if (data instanceof Map) {
            return ((Map)data).get(key);
        }
        return null;
    }

    public static Map<String, Object> getAllParametersFromCache() {
        LocalMemoryCache cache = AppParameterServiceHelper.getLocalCache(RequestContext.get().getAccountId());
        Map<String, Object> data = (Map<String, Object>)cache.get(APPID);
        if (data == null) {
            data = AppParameterServiceHelper.loadFromDB();
            cache.put(APPID, data);
        }
        return data;
    }

    private static void putAppParametersToCache(Map<String, Object> params) {
        Map<String, Object> data = AppParameterServiceHelper.getAllParametersFromCache();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            data.put(entry.getKey(), entry.getValue());
        }
    }

    public static boolean isEnableControl() {
        try {
            return "yes".equals(AppParameterServiceHelper.getParameterFromCache("enable_control"));
        }
        catch (Exception e) {
            logger.warn("get enable_control param value failed", (Throwable)e);
            return false;
        }
    }

    private static LocalMemoryCache getLocalCache(String acctId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(43200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(acctId, "ISC_APP_PARAMETER", info);
    }

    public static AppParam getAppParam() {
        AppParam apm = new AppParam();
        apm.setAppId(APPID);
        apm.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        return apm;
    }

    static {
        try {
            AppParameterServiceHelper.getAllParameters();
        }
        catch (Exception e) {
            logger.warn("unable to load config from T_ISC_APP_PARAMS.", (Throwable)e);
        }
    }
}

