/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.cache.data;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;

public class DataSource
implements ObjectSizeIgnored {
    private long id;
    private long dbLink;
    private String number;
    private DynamicObject cfg;

    public DataSource(DynamicObject cfg) {
        this.id = cfg.getLong("id");
        this.dbLink = cfg.getLong("dblink_id");
        this.number = cfg.getString("number");
        this.cfg = cfg;
    }

    public DynamicObject getConfig() {
        return this.cfg;
    }

    public long getId() {
        return this.id;
    }

    public long getDbLink() {
        if (this.dbLink != 0L) {
            return this.dbLink;
        }
        String message = ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s\uff08%2$s\uff09\u201d\u6ca1\u6709\u6307\u5b9a\u8fde\u63a5\u914d\u7f6e\uff0c\u8bf7\u5230\u201c\u96c6\u6210\u7ba1\u7406 - \u8fde\u63a5\u7ba1\u7406 - \u6570\u636e\u6e90\u7ba1\u7406\u201d\u627e\u5230\u8fd9\u4e2a\u6570\u636e\u6e90\uff0c\u4e3a\u5176\u8bbe\u7f6e\u6b63\u786e\u7684\u8fde\u63a5\u914d\u7f6e\u3002", (String)"DataSource_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        throw new IscBizException(String.format(message, this.cfg.get("name"), this.number));
    }

    public long getDbLinkId() {
        return D.l((Object)this.dbLink);
    }

    public String getNumber() {
        return this.number;
    }

    public static DataSource get(long id) {
        return CacheableObjectManager.get(DataSource.class, id);
    }

    public static DataSource get(String number) {
        return CacheableObjectManager.getByNumber(DataSource.class, number);
    }

    public static DataSource getByDbLink(long dbLink) {
        QFilter filter = new QFilter("dblink", "=", (Object)dbLink);
        return CacheableObjectManager.getByFilter(DataSource.class, filter);
    }

    public static List<DataSource> getAllByDbLink(long dbLink) {
        QFilter filter = new QFilter("dblink", "=", (Object)dbLink);
        return CacheableObjectManager.getAllByFilter(DataSource.class, filter);
    }

    public static DataSource getOneByDbLink(long dbLink) {
        QFilter filter = new QFilter("dblink", "=", (Object)dbLink);
        return CacheableObjectManager.getOneByFilter(DataSource.class, filter);
    }

    static {
        CacheableObjectManager.registerFactory(new CacheableObjectFactory<DataSource>(){

            @Override
            public String entityType() {
                return "isc_data_source";
            }

            @Override
            public DataSource create(DynamicObject cfg) {
                return new DataSource(cfg);
            }

            @Override
            public Class<DataSource> target() {
                return DataSource.class;
            }
        });
    }
}

