/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.cache.data;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.cache.data.type.Field;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;

public class MetaDataSchema
implements ObjectSizeIgnored {
    private DynamicObject cfg;
    private Map<String, Field> items;
    private Field primaryKey;

    private MetaDataSchema(DynamicObject cfg) {
        this.cfg = cfg;
    }

    public DynamicObject getConfig() {
        return this.cfg;
    }

    public static DynamicObject get(long id) {
        return CacheableObjectManager.get(MetaDataSchema.class, (Long)Long.valueOf((long)id)).cfg;
    }

    public static MetaDataSchema getSchema(long id) {
        return CacheableObjectManager.get(MetaDataSchema.class, id);
    }

    public static DynamicObject get(long dataSourceId, String fullname, String ... types) {
        QFilter filter = new QFilter("full_name", "=", (Object)fullname).and(new QFilter("group", "=", (Object)dataSourceId));
        if (types.length > 0) {
            filter = filter.and(new QFilter("type", "in", Arrays.asList(types)));
        }
        return MetaDataSchema.getByFilter(filter);
    }

    public static DynamicObject getOne(List<Long> dataSourceIds, String fullname, String ... types) {
        QFilter filter = new QFilter("full_name", "=", (Object)fullname).and(new QFilter("group", "in", dataSourceIds));
        if (types.length > 0) {
            filter = filter.and(new QFilter("type", "in", Arrays.asList(types)));
        }
        return MetaDataSchema.getOneByFilter(filter);
    }

    public static DynamicObject getOneByNumber(List<Long> dataSourceIds, String number, String ... types) {
        QFilter filter = new QFilter("number", "=", (Object)number).and(new QFilter("group", "in", dataSourceIds));
        if (types.length > 0) {
            filter = filter.and(new QFilter("type", "in", Arrays.asList(types)));
        }
        return MetaDataSchema.getOneByFilter(filter);
    }

    public static DynamicObject getByNumber(long dataSourceId, String number, String ... types) {
        QFilter filter = new QFilter("number", "=", (Object)number).and(new QFilter("group", "=", (Object)dataSourceId));
        if (types.length > 0) {
            filter = filter.and(new QFilter("type", "in", Arrays.asList(types)));
        }
        return MetaDataSchema.getByFilter(filter);
    }

    public static DynamicObject getByFilter(QFilter filter) {
        MetaDataSchema schema = CacheableObjectManager.getByFilter(MetaDataSchema.class, filter);
        return schema == null ? null : schema.cfg;
    }

    public static DynamicObject getOneByFilter(QFilter filter) {
        MetaDataSchema schema = CacheableObjectManager.findOne(MetaDataSchema.class, filter);
        return schema == null ? null : schema.cfg;
    }

    public static MetaDataSchema getOneSchemaByFilter(QFilter filter) {
        return CacheableObjectManager.findOne(MetaDataSchema.class, filter);
    }

    public DataType getDataType(String field) {
        Map<String, Field> items = this.getFields();
        Field f = items.get(field);
        return f == null ? null : f.getDataType();
    }

    public boolean getIsEncrypt(String field) {
        Map<String, Field> items = this.getFields();
        Field f = items.get(field);
        return f == null ? false : f.isEncrypt();
    }

    public String getDataSchema(String field) {
        Map<String, Field> items = this.getFields();
        Field f = items.get(field);
        return f == null ? "" : f.getDataSchema();
    }

    public Field getField(String field) {
        return this.getFields().get(field);
    }

    private Map<String, Field> getFields() {
        Map<String, Field> items = this.items;
        if (items == null) {
            items = this.initDataTypes();
        }
        return items;
    }

    private Map<String, Field> initDataTypes() {
        DynamicObject cfg = this.cfg;
        DynamicObjectCollection c = cfg.getDynamicObjectCollection("prop_entryentity");
        LinkedHashMap<String, Field> items = new LinkedHashMap<String, Field>(c.size());
        Field pk = null;
        boolean hasMultiPK = false;
        for (DynamicObject item : c) {
            Field field = new Field(item, cfg);
            items.put(field.getName(), field);
            if (!field.isPrimaryKey()) continue;
            if (pk == null) {
                pk = field;
                continue;
            }
            hasMultiPK = true;
        }
        this.items = items;
        this.primaryKey = hasMultiPK ? null : pk;
        return items;
    }

    public DataType getPrimaryKeyDataType() {
        Field pk = this.getPrimaryKey();
        if (pk != null) {
            return pk.getDataType();
        }
        return DataTypes.UNKNOWN;
    }

    public Field getPrimaryKey() {
        Field pk = this.primaryKey;
        if (pk == null) {
            pk = this.findPrimaryKey();
        }
        return pk;
    }

    private Field findPrimaryKey() {
        this.getFields();
        return this.primaryKey;
    }

    static {
        CacheableObjectManager.registerFactory(new CacheableObjectFactory<MetaDataSchema>(){

            @Override
            public String entityType() {
                return "isc_metadata_schema";
            }

            @Override
            public MetaDataSchema create(DynamicObject cfg) {
                return new MetaDataSchema(cfg);
            }

            @Override
            public Class<MetaDataSchema> target() {
                return MetaDataSchema.class;
            }
        });
    }
}

