/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.EncryptUtils;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.NetUtil;

public class ConnectorUtil {
    public static final String CURRENT_ACCOUNT = "current_account";
    private static final String FIELD_SECRET = "password";
    private static final Log log = LogFactory.getLog(ConnectorUtil.class);
    private static final String OPEN_3RDAPPS_STR = "open_3rdapps";
    private static final String NUMBER_STR = "number";

    public static void checkAccountId(DynamicObject cfg) {
        if (ConnectorUtil.isThisSystem(cfg)) {
            return;
        }
        if (cfg.getDataEntityType().getProperties().get((Object)CURRENT_ACCOUNT) == null) {
            return;
        }
        String account0 = D.s((Object)cfg.get(CURRENT_ACCOUNT));
        if (account0 == null) {
            ConnectorUtil.updateAccountId(cfg);
        } else if (!account0.equalsIgnoreCase(ConnectorUtil.currentAccount())) {
            String message = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u4e0d\u662f\u5728\u5f53\u524d\u73af\u5883\u8bbe\u7f6e\u7684\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8d26\u5957\u5907\u4efd\u6062\u590d\u65f6\u6ca1\u6709\u8fdb\u884c\u6570\u636e\u8131\u654f\uff0c\u4e3a\u907f\u514d\u53d1\u751f\u6d4b\u8bd5\u73af\u5883\u6570\u636e\u88ab\u540c\u6b65\u5230\u751f\u4ea7\u73af\u5883\u7684\u4e8b\u6545\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u5e76\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ConnectorUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.get("name"), cfg.get(NUMBER_STR));
            throw new IscBizException(message);
        }
    }

    public static void setCurrentAccount(BeforeDoOperationEventArgs args, IDataModel model) {
        if (args.isCancel()) {
            return;
        }
        if (model.getDataEntityType().getProperties().get((Object)CURRENT_ACCOUNT) != null) {
            model.setValue(CURRENT_ACCOUNT, (Object)ConnectorUtil.currentAccount());
        }
    }

    private static String currentAccount() {
        return RequestContext.get().getAccountId();
    }

    private static boolean isThisSystem(DynamicObject cfg) {
        if (D.s((Object)cfg.get("server_ip")) != null) {
            return false;
        }
        return cfg.getDataEntityType().getProperties().get((Object)"bootstrap_servers") == null || D.s((Object)cfg.get("bootstrap_servers")) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAccountId(DynamicObject cfg) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            String sql = "UPDATE " + ConnectorUtil.getTableName(cfg) + " SET fcurrent_account_id = ? WHERE fid = ? ";
            String account = ConnectorUtil.currentAccount();
            Object id = cfg.get("id");
            DbUtil.executeUpdate((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{account, id}), (List)D.asList((Object[])new Integer[]{12, -5}));
            cfg.set(CURRENT_ACCOUNT, (Object)account);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static String getTableName(DynamicObject cfg) {
        return cfg.getDataEntityType().getAlias();
    }

    public static void close(AutoCloseable res) {
        if (res != null) {
            try {
                res.close();
            }
            catch (Throwable t) {
                log.warn("kd.isc.iscb.platform.core.connector.ConnectorUtil.close(AutoCloseable)", t);
            }
        }
    }

    public static String getIscHub(DynamicObject cfg) {
        return ConnectorUtil.getIscHub(cfg.getPkValue());
    }

    public static String getIscHub(Object cfgId) {
        RequestContext ctx = RequestContext.get();
        String s = cfgId + ";" + ctx.getAccountId() + ";" + ctx.getTenantId();
        return Hash.md5((String)s).toUpperCase();
    }

    public static void save(DynamicObject obj) {
        ConnectorUtil.doAction(obj, "save");
    }

    public static void disable(DynamicObject obj) {
        ConnectorUtil.doAction(obj, "disable");
    }

    public static void enable(DynamicObject obj) {
        ConnectorUtil.doAction(obj, "enable");
    }

    public static void release(DynamicObject obj) {
        ConnectorUtil.doAction(obj, "release");
    }

    public static OperationResult doAction(DynamicObject obj, String action) {
        String type = obj.getDataEntityType().getName();
        OperationResult result = OperationServiceHelper.executeOperate((String)action, (String)type, (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create());
        CommonUtil.check(result);
        return result;
    }

    public static void delete(String entity, Object id) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])new Object[]{id}, (OperateOption)OperateOption.create());
        CommonUtil.check(result);
    }

    public static OperationResult doBatchAction(DynamicObject[] list, String action) {
        if (list.length == 0) {
            return null;
        }
        String entity = list[0].getDataEntityType().getName();
        OperationResult result = OperationServiceHelper.executeOperate((String)action, (String)entity, (DynamicObject[])list, (OperateOption)OperateOption.create());
        CommonUtil.check(result);
        return result;
    }

    public static void delete(String entity, int top, QFilter ... filters) {
        if (top > 1000) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6700\u591a\u4e00\u6b21\u5220\u96641000\u884c\u6570\u636e!", (String)"ConnectorUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        int batch = Math.max(0, top);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])filters, null, (int)batch);
        if (!CollectionUtils.isEmpty(ids)) {
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
            CommonUtil.check(result);
        }
    }

    public static Map<String, String> getThirdLoginInfo(DynamicObject cfg, DynamicObject user) {
        String username = D.s((Object)user.getString("username"));
        if (username == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u662f(%s)\u7684\u7528\u6237\u540d\u4e3a\u7a7a\u503c\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4ee3\u7406\u7528\u6237\u3002", (String)"ConnectorUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), user.getString(NUMBER_STR)));
        }
        String password = ConnectorUtil.generatePassword(cfg.getPkValue(), user);
        RequestContext ctx = RequestContext.get();
        DynamicObject app = ConnectorUtil.getThirdApp(cfg, ctx, password);
        HashMap<String, String> info = new HashMap<String, String>(16);
        info.put("appId", app.getString(NUMBER_STR));
        info.put("appSecuret", password);
        info.put("tenantid", ctx.getTenantId());
        info.put("accountId", ctx.getAccountId());
        info.put("clusterName", Instance.getClusterName());
        info.put("user", username);
        info.put("usertype", "UserName");
        info.put("language", "zh_CN");
        info.put("connection_id", cfg.getPkValue().toString());
        info.put("connection_number", cfg.getString(NUMBER_STR));
        info.put("isc_hub", ConnectorUtil.getIscHub(cfg));
        info.put("isc_local_ip", NetUtil.getLocalAddress());
        info.put("accountName", AccountUtils.getAccountById((String)ctx.getAccountId()).getAccountName());
        info.put("userId", D.s((Object)user.getPkValue()));
        info.put("user_pwd", D.s((Object)user.get(FIELD_SECRET)));
        if (ConnectorUtil.passwordRequired()) {
            info.put(FIELD_SECRET, cfg.getString("attr_e1"));
            info.put("logintype", "2");
        }
        return info;
    }

    public static boolean passwordRequired() {
        String tenantId = RequestContext.get().getTenantId();
        String s = SystemPropertyUtils.getProptyByTenant((String)"login_api_is_support_non_password", (String)tenantId);
        return "false".equalsIgnoreCase(s);
    }

    public static String generatePassword(Object id, DynamicObject user) {
        RequestContext ctx = RequestContext.get();
        String key = id + ";" + ctx.getAccountId() + ";" + ctx.getTenantId() + ";" + user.getPkValue() + ";" + user.get(FIELD_SECRET);
        return Long.toHexString(Hash.mur64((byte[])key.getBytes(StandardCharsets.UTF_8)));
    }

    private static DynamicObject getThirdApp(DynamicObject cfg, RequestContext ctx, String password) {
        String number = ConnectorUtil.getThirdAppNumber(cfg);
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER_STR, "=", (Object)number)};
        List list = QueryServiceHelper.queryPrimaryKeys((String)OPEN_3RDAPPS_STR, (QFilter[])filters, null, (int)1);
        if (list.size() > 0) {
            return ConnectorUtil.refreshThirdApp(password, list.get(0));
        }
        return ConnectorUtil.createThirdApp(cfg, ctx, number, password);
    }

    public static String getThirdAppNumber(DynamicObject cfg) {
        String number = "ISC_" + cfg.getString("database_type").toUpperCase() + "_" + Hash.mur32((Object[])new Object[]{cfg.getPkValue()});
        if (number.length() > 20 && (number = "I" + cfg.getPkValue()).length() > 20) {
            number = D.s((Object)cfg.getPkValue());
        }
        return number;
    }

    private static DynamicObject refreshThirdApp(String password, Object id) {
        DynamicObject app = BusinessDataServiceHelper.loadSingle((Object)id, (String)OPEN_3RDAPPS_STR);
        app.set("syspwd", (Object)EncryptUtils.encryptPSW((String)password));
        app.set("status", (Object)"C");
        app.set("enable", (Object)1);
        ExecutionData.execute(app, "save", CommonUtil.getSkipPermissionOption());
        return app;
    }

    private static DynamicObject createThirdApp(DynamicObject cfg, RequestContext ctx, String number, String password) {
        DynamicObject app = BusinessDataServiceHelper.newDynamicObject((String)OPEN_3RDAPPS_STR);
        app.set(NUMBER_STR, (Object)number);
        app.set("name", (Object)(cfg.get("name") + "_" + Hash.mur16((Object[])new Object[]{cfg.getPkValue()})));
        app.set("status", (Object)"C");
        app.set("enable", (Object)1);
        app.set("syspwd", (Object)EncryptUtils.encryptPSW((String)password));
        app.set("creator", (Object)ctx.getUserId());
        app.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        ExecutionData.execute(app, "save", CommonUtil.getSkipPermissionOption());
        return app;
    }

    public static Object getPwd(DynamicObject cfg) {
        String newpwd = cfg.getString("newpwd");
        if (newpwd != null && newpwd.length() > 0) {
            return newpwd;
        }
        return cfg.get(FIELD_SECRET);
    }
}

