/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;

public class ConnectorVersion {
    private static final LocalMemoryCache cache;

    public static double get(String url) {
        Double version = (Double)cache.get(url);
        if (version == null) {
            version = ConnectorVersion.load(url);
            cache.put(url, (Object)version);
        }
        return version;
    }

    public static void remove(String url) {
        cache.remove(new String[]{url});
    }

    private static Double load(String url) {
        try {
            String version;
            switch (version = NetUtil.httpRead((String)url, (String)"UTF-8")) {
                case "OK": {
                    return 1.0;
                }
                case "NOP": {
                    return 1.0;
                }
            }
            return Double.valueOf(version);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(360000);
        info.setMaxMemSize(512);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        cache = commonCacheFactory.$getOrCreateLocalMemoryCache("ISCV", "bd", info);
    }
}

