/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.factory.FactoryManager;

public final class DatabaseType {
    public static ConnectionFactory get(String type) {
        Object factory = FactoryManager.get(type);
        return DatabaseType.check(type, factory);
    }

    public static ConnectionFactory find(String type) {
        String account = RequestContext.get().getAccountId();
        return DatabaseType.find(type, account);
    }

    public static ConnectionFactory find(String type, String account) {
        Object factory = FactoryManager.find(type, account);
        if (factory == null) {
            return null;
        }
        return DatabaseType.check(type, factory);
    }

    private static ConnectionFactory check(String type, Object factory) {
        if (factory instanceof ConnectionFactory) {
            return (ConnectionFactory)factory;
        }
        String text = String.format(ResManager.loadKDString((String)"\u7c7b\u578b\uff08%1$s\uff09\u5173\u8054\u7684\u5de5\u5382\u7c7b\uff08%2$s\uff09\u6ca1\u6709\u5b9e\u73b0\u63a5\u53e3\uff08ConnectionFactory\uff09\uff01", (String)"DatabaseType_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type, factory.getClass().getName());
        throw new IllegalArgumentException(text);
    }

    public static String getForm(String type) {
        return FactoryManager.getForm(type);
    }

    public static void resetEnvironment() {
        FactoryManager.resetEnvironment();
        RequestContext ctx = RequestContext.get();
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)FactoryManager.class.getName(), (String)"resetEnvironmentForMQ", (Object[])new String[]{ctx.getTenantId(), ctx.getAccountId()});
    }
}

