/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apacheftp;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.apacheftp.ApacheFtpUtil;
import kd.isc.iscb.platform.core.connector.ftp.FtpConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ftp.FtpConnector;
import kd.isc.iscb.platform.core.connector.ftp.util.FtpMode;
import kd.isc.iscb.platform.core.connector.ftp.util.IscFtpException;
import kd.isc.iscb.platform.core.connector.ftp.util.PathInfo;
import kd.isc.iscb.platform.core.connector.sunftp.FtpConfig;
import kd.isc.iscb.platform.core.connector.sunftp.FtpFile;
import kd.isc.iscb.platform.core.connector.sunftp.FtpUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.misc.StringUtil;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class ApacheFtpConnectionFactory
implements ConnectionFactory,
FtpConnector {
    private static final Log logger = LogFactory.getLog(ApacheFtpConnectionFactory.class);

    @Override
    public FtpConnectionWrapper create(DynamicObject cfg) {
        return new FtpConnectionWrapper(this, cfg);
    }

    @Override
    public void test(ConnectionWrapper cn) {
        cn.ensureFluidControl();
        FtpConnectionWrapper ftpCn = (FtpConnectionWrapper)cn;
        ftpCn.getWorkingDirectory();
    }

    @Override
    public String getWorkingDirectory(DynamicObject cfg) {
        FTPClient client = this.createFtpClient(cfg);
        try {
            String string = client.printWorkingDirectory();
            return string;
        }
        catch (IOException e) {
            throw new IscFtpException(e);
        }
        finally {
            this.closeConnect(client);
        }
    }

    @Override
    public List<FtpFile> list(DynamicObject cfg, String dirPath) {
        if (StringUtil.isEmpty((String)dirPath)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u76ee\u5f55\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApacheFtpConnectionFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        FTPClient client = this.createFtpClient(cfg);
        try {
            List<FtpFile> list = ApacheFtpUtil.list(client, dirPath);
            return list;
        }
        catch (IOException e) {
            throw new IscFtpException(e);
        }
        finally {
            this.closeConnect(client);
        }
    }

    @Override
    public boolean delete(DynamicObject cfg, String path) {
        if (StringUtil.isEmpty((String)path)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApacheFtpConnectionFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        FTPClient client = this.createFtpClient(cfg);
        try {
            ApacheFtpUtil.deleteFile(client, path);
        }
        catch (Exception e) {
            throw new IscFtpException(e);
        }
        finally {
            this.closeConnect(client);
        }
        return true;
    }

    @Override
    public Object get(DynamicObject cfg, PathInfo pathInfo, String fileName, long restartOffset) {
        if (StringUtil.isEmpty((String)fileName)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApacheFtpConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        FTPClient client = this.createFtpClient(cfg);
        try {
            long maxFileSize;
            FTPFile[] ftpFiles = client.listFiles(pathInfo.getDirPath() + fileName);
            if (ftpFiles.length == 0) {
                Object var8_8 = null;
                return var8_8;
            }
            long size = ftpFiles[0].getSize();
            if (size > (maxFileSize = FtpUtil.getMaxFileSize(D.s((Object)cfg.get("attr8"))))) {
                throw new IscFtpException(String.format(ResManager.loadKDString((String)"\u6700\u5927\u652f\u6301\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u4e3a[%1$s \u5b57\u8282], \u5b9e\u9645\u6587\u4ef6\u5927\u5c0f\u4e3a[%2$s \u5b57\u8282]\u3002", (String)"ApacheFtpConnectionFactory_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), maxFileSize, size));
            }
            Object object = ApacheFtpUtil.readFileContent(client, pathInfo, fileName, restartOffset);
            return object;
        }
        catch (IOException e) {
            throw new IscFtpException(e);
        }
        finally {
            this.closeConnect(client);
        }
    }

    @Override
    public boolean put(DynamicObject cfg, String dirPath, String fileName, InputStream fileStream, boolean isUpdate) {
        if (StringUtil.isEmpty((String)dirPath)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApacheFtpConnectionFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((String)fileName)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApacheFtpConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        FTPClient client = this.createFtpClient(cfg);
        try {
            ApacheFtpUtil.mkdir(client, dirPath);
            client.storeFile(PathInfo.getDirPath(dirPath) + fileName, fileStream);
        }
        catch (IOException e) {
            throw new IscFtpException(e);
        }
        finally {
            this.closeConnect(client);
        }
        return true;
    }

    @Override
    public boolean rmdir(DynamicObject cfg, String dirPath) {
        if (StringUtil.isEmpty((String)dirPath)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u76ee\u5f55\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApacheFtpConnectionFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        FTPClient client = this.createFtpClient(cfg);
        try {
            ApacheFtpUtil.rmdir(client, dirPath);
        }
        catch (IOException e) {
            throw new IscFtpException(e);
        }
        finally {
            this.closeConnect(client);
        }
        return true;
    }

    @Override
    public boolean mkdir(DynamicObject cfg, String dirPath) {
        if (StringUtil.isEmpty((String)dirPath)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u76ee\u5f55\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApacheFtpConnectionFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        FTPClient client = this.createFtpClient(cfg);
        try {
            ApacheFtpUtil.mkdir(client, dirPath);
        }
        catch (IOException e) {
            throw new IscFtpException(e);
        }
        finally {
            this.closeConnect(client);
        }
        return true;
    }

    @Override
    public boolean exists(DynamicObject cfg, String path) {
        if (StringUtil.isEmpty((String)path)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApacheFtpConnectionFactory_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        FTPClient client = this.createFtpClient(cfg);
        try {
            boolean bl = ApacheFtpUtil.exists(client, path);
            return bl;
        }
        catch (IOException e) {
            throw new IscFtpException(e);
        }
        finally {
            this.closeConnect(client);
        }
    }

    private FTPClient createFtpClient(DynamicObject dynamicObject) {
        FtpConfig config = new FtpConfig(dynamicObject);
        FTPClient client = new FTPClient();
        try {
            client.setCharset(config.getCharset());
            client.setControlEncoding(D.s((Object)config.getCharset()));
            client.setConnectTimeout(config.getConnectionTimeout());
            client.setDataTimeout(config.getConnectionTimeout());
            client.connect(config.getHost(), config.getPort());
            client.login(config.getUser(), config.getPassword());
            client.setFileType(2);
            if (config.getMode() == FtpMode.Passive) {
                client.enterLocalPassiveMode();
            } else {
                client.enterLocalActiveMode();
            }
            if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                throw new IscBizException(client.getReplyString());
            }
        }
        catch (Exception e) {
            this.closeConnect(client);
            throw new IscBizException((Throwable)e);
        }
        return client;
    }

    private void closeConnect(FTPClient ftpClient) {
        try {
            if (ftpClient != null) {
                ftpClient.logout();
            }
        }
        catch (IOException e) {
            throw new IscBizException((Throwable)e);
        }
        finally {
            if (ftpClient != null && ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    logger.info("ftp disconnect fail :" + e);
                }
            }
        }
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"FTP(apache)\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u201c\u540c\u6b65\u5143\u6570\u636e\u5217\u8868\u201d\u64cd\u4f5c\u3002", (String)"ApacheFtpConnectionFactory_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        throw new UnsupportedOperationException();
    }
}

