/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.trigger.AbstractTriggerDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.trigger.TriggerExecuteApiDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.trigger.TriggerPushApiDocGenerator;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class ExportDocForDataCopyTriggerAPI {
    private static final String EXECUTION_TYPE = "execution_type";
    public static final String EXECUTE = "EXECUTE";
    public static final String PUSH = "PUSH";
    private static final String DISPATCHER_URL = "/kapi/app/iscb/DcTriggerApiDispatcher";

    public static String generateDoc(DynamicObject triggerApi) {
        File file = DocFileUtil.newTempFile();
        OutputStream out = null;
        try {
            out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            Document pdf = new Document(PageSize.A4);
            PdfWriter.getInstance((Document)pdf, (OutputStream)out);
            pdf.open();
            ExportDocForDataCopyTriggerAPI.addInputsAndOutPuts(pdf, triggerApi);
            pdf.close();
        }
        catch (DocumentException | IOException e) {
            try {
                throw ApicError.PDF_WRITER_ERROR.wrap(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(out);
                throw throwable;
            }
        }
        DbUtil.close((OutputStream)out);
        return file.getAbsolutePath();
    }

    private static void addInputsAndOutPuts(Document pdf, DynamicObject triggerApi) {
        AbstractTriggerDocGenerator generator;
        String type = triggerApi.getString(EXECUTION_TYPE);
        ApiInfo apiInfo = new ApiInfo(DISPATCHER_URL, "apiNumber=" + triggerApi.get("number"), D.s((Object)triggerApi.get("number")), "isc_apic_by_dc_trigger");
        if (EXECUTE.equals(type)) {
            generator = new TriggerExecuteApiDocGenerator(pdf, triggerApi, apiInfo);
        } else if (PUSH.equals(type)) {
            generator = new TriggerPushApiDocGenerator(pdf, triggerApi, apiInfo);
        } else {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u63a5\u53e3\u7c7b\u578b-%s", (String)"ExportDocForDataCopyTriggerAPI_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
        }
        generator.generatePdf();
    }
}

