/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.serviceflow.ServiceFlowApiDocGenerator;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class ExportDocForServiceFlowAPI {
    public static String generateDoc(DynamicObject sfApi) {
        File file = DocFileUtil.newTempFile();
        OutputStream out = null;
        Document pdf = new Document(PageSize.A4);
        try {
            out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            PdfWriter.getInstance((Document)pdf, (OutputStream)out);
            pdf.open();
            ApiInfo apiInfo = new ApiInfo("/kapi/app/iscb/sf", "", D.s((Object)sfApi.get("number")), "isc_apic_by_sf");
            new ServiceFlowApiDocGenerator(pdf, sfApi, apiInfo).generatePdf();
        }
        catch (DocumentException | IOException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap(e);
        }
        finally {
            pdf.close();
            DbUtil.close((OutputStream)out);
        }
        return file.getAbsolutePath();
    }
}

