/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.util.Numeric;

public class JsonSampleUtil {
    private static final String DATA_TYPE_REF = "REF";
    private static final String FIELD_DATA_SCHEMA = "data_schema";
    private static final String FIELD_DATA_TYPE = "data_type";
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String ENTITY_ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String DATA_TYPE_ENTRIES = "ENTRIES";

    public static String toJsonString(long metaId) {
        return JSON.toJSONString((Object)JsonSampleUtil.toJSONObject(metaId, null), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
    }

    public static JSONObject toJSONObject(Map<String, Object> requires) {
        JSONObject data = new JSONObject();
        for (Map.Entry<String, Object> item : requires.entrySet()) {
            String key = item.getKey();
            if (item.getValue() instanceof Map) {
                JSONArray array = new JSONArray();
                array.add((Object)JsonSampleUtil.toJSONObject(JsonSampleUtil.getSubRequires(requires, key)));
                data.put(key, (Object)array);
                continue;
            }
            data.put(key, null);
        }
        return data;
    }

    public static JSONObject toJSONObject(long metaId, Map<String, Object> requires) {
        return JsonSampleUtil.toJSONObject(metaId, requires, false);
    }

    public static JSONObject toJSONObject(long metaId, Map<String, Object> requires, boolean onlyMustInput) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)ENTITY_ISC_METADATA_SCHEMA);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        JSONObject data = new JSONObject(new LinkedHashMap());
        for (DynamicObject p : properties) {
            boolean required = D.x((Object)p.getString("required"));
            String field = p.getString("prop_name");
            if (!JsonSampleUtil.isRequiredField(requires, field) || onlyMustInput && !required) continue;
            String type = p.getString(FIELD_DATA_TYPE);
            String schema = p.getString(FIELD_DATA_SCHEMA);
            if (DATA_TYPE_ENTRIES.equals(type)) {
                JsonSampleUtil.generateEntrySampleData(requires, onlyMustInput, meta, data, field, schema);
                continue;
            }
            if (requires != null && DATA_TYPE_REF.equals(type) && requires.get(field) instanceof Map) {
                JsonSampleUtil.generateRefSampleData(requires, onlyMustInput, meta, data, field, schema);
                continue;
            }
            Object value = JsonSampleUtil.getDefaultValue(meta, type, schema);
            data.put(field, value);
        }
        return data;
    }

    private static void generateRefSampleData(Map<String, Object> requires, boolean onlyMustInput, DynamicObject meta, JSONObject data, String field, String schema) {
        JSONObject obj = new JSONObject();
        DynamicObject entry = JsonSampleUtil.findMetaByDataSchema(meta, schema);
        if (entry == null) {
            data.put(field, (Object)obj);
        } else {
            obj = JsonSampleUtil.toJSONObject(D.l((Object)entry.getPkValue()), JsonSampleUtil.getSubRequires(requires, field), onlyMustInput);
            data.put(field, (Object)obj);
        }
    }

    private static void generateEntrySampleData(Map<String, Object> requires, boolean onlyMustInput, DynamicObject meta, JSONObject data, String field, String schema) {
        JSONArray array = new JSONArray();
        DynamicObject entry = JsonSampleUtil.findMetaByDataSchema(meta, schema);
        if (entry == null) {
            data.put(field, Collections.emptyList());
        } else {
            JSONObject sub = JsonSampleUtil.toJSONObject(D.l((Object)entry.getPkValue()), JsonSampleUtil.getSubRequires(requires, field), onlyMustInput);
            array.add((Object)sub);
            data.put(field, (Object)array);
        }
    }

    public static JSONObject toJSONObjectParam(long metaId, Map<String, Object> requires) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)ENTITY_ISC_METADATA_SCHEMA);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("param_entryentity");
        JSONObject data = new JSONObject(requires);
        for (DynamicObject p : properties) {
            String field = p.getString("param_number");
            String type = p.getString("param_type");
            String schema = p.getString("param_schema");
            if (DATA_TYPE_ENTRIES.equals(type)) {
                JSONArray array = new JSONArray();
                DynamicObject entry = JsonSampleUtil.findMetaByDataSchema(meta, schema);
                if (entry == null) {
                    data.put(field, Collections.emptyList());
                    continue;
                }
                JSONObject sub = JsonSampleUtil.toJSONObjectParam(D.l((Object)entry.getPkValue()), JsonSampleUtil.getSubRequires(requires, field));
                array.add((Object)sub);
                data.put(field, (Object)array);
                continue;
            }
            Object value = JsonSampleUtil.getDefaultValue(meta, type, schema);
            data.put(field, value);
        }
        return data;
    }

    public static JSONObject toJSONObjectResult(long metaId, Map<String, Object> requires) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)ENTITY_ISC_METADATA_SCHEMA);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("result_entryentity");
        JSONObject data = new JSONObject(new LinkedHashMap());
        for (DynamicObject p : properties) {
            String field = p.getString("result_number");
            String type = p.getString("result_type");
            String schema = p.getString("result_schema");
            if (DATA_TYPE_ENTRIES.equals(type)) {
                JSONArray array = new JSONArray();
                DynamicObject entry = JsonSampleUtil.findMetaByDataSchema(meta, schema);
                if (entry == null) {
                    data.put(field, Collections.emptyList());
                    continue;
                }
                JSONObject sub = JsonSampleUtil.toJSONObjectResult(D.l((Object)entry.getPkValue()), JsonSampleUtil.getSubRequires(requires, field));
                array.add((Object)sub);
                data.put(field, (Object)array);
                continue;
            }
            Object value = JsonSampleUtil.getDefaultValue(meta, type, schema);
            data.put(field, value);
        }
        return data;
    }

    public static JSONObject parseRequires(long metaId, Map<String, Object> requires) {
        Assert.notNull(requires, (String)ResManager.loadKDString((String)"\u53d6\u6570\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"JsonSampleUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DynamicObject meta = D.l((Object)metaId) != 0L ? BusinessDataServiceHelper.loadSingle((Object)metaId, (String)ENTITY_ISC_METADATA_SCHEMA) : BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_METADATA_SCHEMA);
        DynamicObjectCollection propEntries = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        DynamicObject defaultProp = new DynamicObject(propEntries.getDynamicObjectType());
        Map<String, DynamicObject> properties = JsonSampleUtil.collectProperties(propEntries);
        JSONObject data = new JSONObject(new LinkedHashMap());
        for (Map.Entry<String, Object> entry : requires.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            DynamicObject prop = properties.getOrDefault(key, defaultProp);
            String type = prop.getString(FIELD_DATA_TYPE);
            String schema = prop.getString(FIELD_DATA_SCHEMA);
            if (value instanceof Map) {
                DynamicObject subMeta = JsonSampleUtil.findMetaByDataSchema(meta, schema);
                JSONObject sub = JsonSampleUtil.parseRequires(D.l((Object)subMeta.getPkValue()), JsonSampleUtil.getSubRequires(requires, key));
                if (DATA_TYPE_REF.equals(type)) {
                    data.put(key, (Object)sub);
                    continue;
                }
                JSONArray array = new JSONArray();
                array.add((Object)sub);
                data.put(key, (Object)array);
                continue;
            }
            data.put(key, JsonSampleUtil.getDefaultValue(meta, type, schema));
        }
        return data;
    }

    private static Map<String, DynamicObject> collectProperties(DynamicObjectCollection collection) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(collection.size());
        for (DynamicObject o : collection) {
            map.put(o.getString("prop_name"), o);
        }
        return map;
    }

    private static boolean isRequiredField(Map<String, Object> requires, String field) {
        if (requires == null) {
            return true;
        }
        return requires.containsKey(field);
    }

    private static Map<String, Object> getSubRequires(Map<String, Object> requires, String key) {
        if (requires == null) {
            return null;
        }
        Object value = requires.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u53d6\u6570\u5b57\u6bb5\u5e94\u4e3amap, \u5b9e\u9645\u4e3a\uff1a%2$s", (String)"JsonSampleUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key, value));
    }

    public static Object getDefaultValue(DynamicObject meta, String dataType, String dataSchema) {
        switch (dataType) {
            case "string": 
            case "ml_string": {
                return "";
            }
            case "boolean": {
                return Boolean.FALSE;
            }
            case "BigDecimal": {
                return BigDecimal.ZERO;
            }
            case "integer": 
            case "long": {
                return 0;
            }
            case "boid": {
                return null;
            }
            case "ENUM": {
                return JsonSampleUtil.getEnumValue(meta, dataSchema);
            }
            case "REF": {
                return JsonSampleUtil.getRefValue(meta, dataSchema);
            }
            case "datetime": {
                return "1970-01-01 00:00:00";
            }
        }
        return null;
    }

    public static Object getRefValue(DynamicObject meta, String dataSchema) {
        DynamicObject ref = JsonSampleUtil.findMetaByDataSchema(meta, dataSchema);
        if (ref == null || CollectionUtils.isEmpty(ref.getDynamicObjectCollection(PROP_ENTRYENTITY))) {
            return null;
        }
        DynamicObjectCollection properties = ref.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject p : properties) {
            if (!D.x((Object)p.get("is_primary_key"))) continue;
            return JsonSampleUtil.getDefaultValue(meta, p.getString(FIELD_DATA_TYPE), p.getString(FIELD_DATA_SCHEMA));
        }
        return null;
    }

    public static Object getEnumValue(DynamicObject meta, String dataSchema) {
        DynamicObject enumMeta = JsonSampleUtil.findMetaByDataSchema(meta, dataSchema);
        if (enumMeta == null || CollectionUtils.isEmpty(enumMeta.getDynamicObjectCollection("consts_entryentity"))) {
            return null;
        }
        DynamicObject item = (DynamicObject)enumMeta.getDynamicObjectCollection("consts_entryentity").get(0);
        String value = item.getString("const_value");
        if (StringUtils.isNumericString((String)value)) {
            return Numeric.parse((String)value);
        }
        return value;
    }

    public static DynamicObject findMetaByDataSchema(DynamicObject meta, String dataSchema) {
        QFilter filter = new QFilter("group", "=", meta.get("group_id")).and("number", "=", (Object)dataSchema);
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_ISC_METADATA_SCHEMA, (String)"id", (QFilter[])new QFilter[]{filter});
        if (object == null) {
            return BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_METADATA_SCHEMA);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)object.get("id"), (String)ENTITY_ISC_METADATA_SCHEMA);
    }
}

