/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.apixml;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.AbstractExportApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;

public class ExportMetaApiToXml
extends AbstractExportApiToXml {
    private static final String FILTER_ENTRIES = "filter_entries";
    private final DynamicObject meta;

    public ExportMetaApiToXml(DynamicObject api) {
        super(api);
        this.meta = BusinessDataServiceHelper.loadSingle((Object)this.api.getLong("metadata_id"), (String)"isc_metadata_schema");
        this.apiInfo = new ApiInfo("/kapi/app/iscb/meta", "", D.s((Object)api.get("number")), "isc_apic_by_meta_schema");
    }

    @Override
    protected String getFileName() {
        return "xml/metaTemplete.xml";
    }

    @Override
    protected void setInputTable() {
        DynamicObjectCollection params = this.api.getDynamicObjectCollection("inputs");
        if (params.isEmpty()) {
            if (!"EXECUTE".equals(this.api.getString("operation"))) {
                DynamicObjectCollection list = this.meta.getDynamicObjectCollection("prop_entryentity");
                this.setTable(list, "prop_name", this.meta, ApiToXmlUtil.isInput("prop_name"));
            }
        } else {
            this.setTable(params, "input_field", this.meta, ApiToXmlUtil.isInput("input_field"));
        }
    }

    @Override
    public void setInput(ApiToXmlPropStruct it, int ik, int deep, int line, int size) {
        ArrayList input = (ArrayList)this.info.get("input_table");
        if (input == null) {
            input = new ArrayList(8);
        }
        HashMap<String, Object> item = new HashMap<String, Object>(7);
        item.put("index", ik);
        item.put("field", ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(this.meta, it.getName()));
        String dataType = CommonUtil.isEmpty(it.getDataType()) ? ApiToXmlUtil.getProperty(this.meta, it.getName(), "data_type") : it.getDataType();
        item.put("dataType", dataType);
        String desc = CommonUtil.isEmpty(it.getDesc()) ? ApiToXmlUtil.getProperty(this.meta, it.getName(), "prop_label") : it.getDesc();
        item.put("desc", ApiToXmlUtil.formatDesc(desc));
        item.put("pk", it.isTrueOne() ? Character.valueOf('Y') : null);
        item.put("need", it.isTrueTwo() ? Character.valueOf('Y') : null);
        item.put("jk", it.isTrueThree() ? Character.valueOf('Y') : null);
        input.add(item);
        this.info.put("input_table", input);
    }

    @Override
    protected void setInputApiStruct(DynamicObjectCollection inputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        for (DynamicObject it : inputs) {
            Boolean jk;
            Boolean need;
            Boolean pk;
            if (!this.api.getDynamicObjectCollection("inputs").isEmpty()) {
                String inputField = it.getString("input_field");
                String inputDataType = it.getString("input_data_type");
                this.addEnumTable(inputDataType);
                String inputDescription = it.getString("input_description");
                pk = it.getBoolean("input_is_pk");
                need = it.getBoolean("input_is_required");
                jk = it.getBoolean("input_is_judge_key");
                apiStruct.put(inputField, new ApiToXmlPropStruct(inputField, inputDataType, inputDescription, pk, need, jk));
                if (ApiToXmlUtil.isEntries(inputDataType)) continue;
                supplier.add(it);
                continue;
            }
            String propName = it.getString("prop_name");
            String dataType = it.getString("data_type");
            if (ApiToXmlUtil.isEnum(dataType)) {
                this.setEnumTable(dataType, it.getString("data_schema"));
            }
            String propLabel = it.getString("prop_label");
            pk = it.getBoolean("is_primary_key");
            need = it.getBoolean("required");
            jk = it.getBoolean("prop_customize");
            apiStruct.put(propName, new ApiToXmlPropStruct(propName, dataType, propLabel, need, pk, jk));
            if (ApiToXmlUtil.isEntries(dataType)) continue;
            supplier.add(it);
        }
    }

    private void addEnumTable(String inputDataType) {
        int i = inputDataType.indexOf(40);
        if (i > -1) {
            String dataType = inputDataType.substring(0, i);
            String dataSchema = inputDataType.substring(i + 1, inputDataType.length() - 1);
            if (ApiToXmlUtil.isEnum(dataType)) {
                this.setEnumTable(dataType, dataSchema);
            }
        }
    }

    @Override
    protected void setOutputApiStruct(DynamicObjectCollection outputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        for (DynamicObject it : outputs) {
            String outputField = it.getString("output_field");
            String outputDataType = it.getString("output_data_type");
            this.addEnumTable(outputDataType);
            String outputDescription = it.getString("output_description");
            apiStruct.put(outputField, new ApiToXmlPropStruct(outputField, outputDataType, outputDescription));
            if (ApiToXmlUtil.isEntries(outputDataType)) continue;
            supplier.add(it);
        }
    }

    @Override
    protected void setOutputTable() {
        DynamicObjectCollection params = this.api.getDynamicObjectCollection("outputs");
        this.setTable(params, "output_field", this.meta, ApiToXmlUtil.isInput("output_field"));
    }

    @Override
    public void setOutput(ApiToXmlPropStruct it, int ik, int deep, int line, int size) {
        ArrayList output = (ArrayList)this.info.get("output_table");
        if (output == null) {
            output = new ArrayList(8);
        }
        HashMap<String, Object> item = new HashMap<String, Object>(7);
        item.put("index", ik);
        item.put("field", ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(this.meta, it.getName()));
        String dataType = CommonUtil.isEmpty(it.getDataType()) ? ApiToXmlUtil.getProperty(this.meta, it.getName(), "data_type") : it.getDataType();
        item.put("dataType", dataType);
        String desc = CommonUtil.isEmpty(it.getDesc()) ? ApiToXmlUtil.getProperty(this.meta, it.getName(), "prop_label") : it.getDesc();
        item.put("desc", ApiToXmlUtil.formatDesc(desc));
        output.add(item);
        this.info.put("output_table", output);
    }

    public static boolean hasFilter(DynamicObject api) {
        return !CollectionUtils.isEmpty(api.getDynamicObjectCollection(FILTER_ENTRIES));
    }

    @Override
    protected void setSample(Map<String, Object> requires, String sampleName, DynamicObject meta, boolean isInput) {
        String sample;
        if (isInput) {
            JSONObject inputData = "EXECUTE".equals(this.api.getString("operation")) || ExportMetaApiToXml.hasFilter(this.api) ? JsonSampleUtil.toJSONObjectParam(meta.getLong("id"), requires) : JsonSampleUtil.toJSONObject(meta.getLong("id"), requires);
            sample = JSON.toJSONString((Object)inputData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replace("\t", "    ");
        } else {
            sample = ApiToXmlUtil.getOutputJsonExample(this.api, meta);
        }
        sample = sample.replace("\n", "</w:t></w:r>\u3000</w:p><w:p><w:r><w:t>\u3000\u3000");
        this.info.put(sampleName, sample);
    }

    private void setEnumTable(String dataType, String dataSchema) {
        String type = this.meta.getString("type");
        if (!MetaType.TABLE.name().equals(type) && !MetaType.VIEW.name().equals(type)) {
            String title;
            ArrayList<Map<String, Object>> complexModel = (ArrayList<Map<String, Object>>)this.info.get("complexModel");
            if (null == complexModel) {
                complexModel = new ArrayList<Map<String, Object>>();
            }
            if (!this.isInfoHasThisEnum(title = dataType + "(" + dataSchema + ")", complexModel)) {
                HashMap<String, Object> item = new HashMap<String, Object>(2);
                item.put("title", title);
                List<Map<String, Object>> complexModelTable = this.getEnum(this.meta, dataSchema);
                item.put("table", complexModelTable);
                complexModel.add(item);
                this.info.put("complexModel", complexModel);
            }
        }
    }

    private boolean isInfoHasThisEnum(String title, List<Map<String, Object>> complexModel) {
        for (Map<String, Object> enumModel : complexModel) {
            for (Map.Entry<String, Object> entry : enumModel.entrySet()) {
                if (title == null || !(entry.getValue() instanceof String) || !title.equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private List<Map<String, Object>> getEnum(DynamicObject meta, String dataSchema) {
        DynamicObject dynamicObject = JsonSampleUtil.findMetaByDataSchema(meta, dataSchema);
        if (dynamicObject == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("consts_entryentity");
        return this.getEnumTable(entries);
    }

    private List<Map<String, Object>> getEnumTable(DynamicObjectCollection entries) {
        int index = 0;
        ArrayList<Map<String, Object>> table = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject it : entries) {
            HashMap<String, Object> item = new HashMap<String, Object>(4);
            item.put("index", ++index);
            item.put("name", it.getString("const_value"));
            item.put("desc", it.getString("const_label"));
            item.put("other", it.getString("const_remark"));
            table.add(item);
        }
        return table;
    }
}

