/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.apixml;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.AbstractExportApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.serviceflow.ServiceFlowApiDocGenerator;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;

public class ExportServiceFlowApiToXml
extends AbstractExportApiToXml {
    private static final String FIELD_PROP_NAME = "prop_name";

    public ExportServiceFlowApiToXml(DynamicObject api) {
        super(api);
        this.apiInfo = new ApiInfo("", api.getString("number"), "isc_apic_by_sf");
    }

    @Override
    protected String getFileName() {
        if (this.api.getBoolean("asyn")) {
            return "xml/serviceFlowAsynTemplete.xml";
        }
        return "xml/serviceFlowTemplete.xml";
    }

    @Override
    protected void setInputTable() {
        long flowId = ServiceFlowParser.findReleasedFlowId(this.api.getLong("service_flow_id"));
        List variables = ServiceFlowParser.getFlow(flowId).getInputVariables();
        ArrayList<Object> input = new ArrayList<Object>();
        HashMap<String, Object> requires = new HashMap<String, Object>(variables.size());
        int index = 0;
        int line = 0;
        for (Variable var : variables) {
            String dataType = D.s((Object)var.getType());
            index = this.setTableColumByVariable(index, var, dataType, input, line++, 0, variables.size());
            String defaultValue = var.getInitValue() == null ? null : ((String[])var.getInitValue())[0];
            this.setSampleStruct(requires, var, defaultValue);
            if (!ApiToXmlUtil.isVariant(dataType)) continue;
            index = this.setSampleVariant(input, index, var, 1);
        }
        this.setSample(requires, "inputSample", null, true);
        this.info.put("input_table", input);
    }

    private int setSampleVariant(List<Object> input, int index, Variable var, int deep) {
        Map varDefine = (Map)var.getAttribute("define");
        if ("isc_metadata_schema".equalsIgnoreCase(D.s(varDefine.get("category")))) {
            DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)D.s(varDefine.get("type")), (String)"isc_metadata_schema");
            return this.setTableByMeta(input, index, item, deep);
        }
        return index;
    }

    private int setTableByMeta(List<Object> input, int index, DynamicObject meta, int deep) {
        DynamicObjectCollection list = meta.getDynamicObjectCollection("prop_entryentity");
        int l = 0;
        for (DynamicObject metaEntry : list) {
            index = this.setTableColumByMeta(index, metaEntry, input, l++, deep, list.size());
            if (!ApiToXmlUtil.isEntries(metaEntry.getString("data_type"))) continue;
            DynamicObject metaEntries = JsonSampleUtil.findMetaByDataSchema(meta, metaEntry.getString("data_schema"));
            DynamicObjectCollection entryList = metaEntries.getDynamicObjectCollection("prop_entryentity");
            int line = 0;
            for (DynamicObject entry : entryList) {
                index = this.setTableColumByMeta(index, entry, input, line++, deep + 1, entryList.size());
            }
        }
        return index;
    }

    private int setTableColumByVariable(int index, Variable var, String dataType, List<Object> input, int line, int deep, int size) {
        HashMap<String, Object> item = new HashMap<String, Object>(5);
        item.put("field", ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + var.getName());
        item.put("index", ++index);
        item.put("desc", var.getTitle());
        item.put("dataType", ApiToXmlUtil.translateType(dataType));
        item.put("isArray", ((VariableImpl)var).isArray() ? Character.valueOf('Y') : "");
        input.add(item);
        return index;
    }

    private int setTableColumByMeta(int index, DynamicObject entry, List<Object> input, int line, int deep, int size) {
        HashMap<String, Object> item = new HashMap<String, Object>(5);
        item.put("field", ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + entry.getString(FIELD_PROP_NAME));
        item.put("index", ++index);
        item.put("desc", entry.getString("prop_label"));
        item.put("dataType", ApiToXmlUtil.translateType(entry.getString("data_type")));
        item.put("isArray", "");
        input.add(item);
        return index;
    }

    @Override
    protected void setOutputTable() {
        long flowId = ServiceFlowParser.findReleasedFlowId(this.api.getLong("service_flow_id"));
        List variables = ServiceFlowParser.getFlow(flowId).getOutputVariables();
        if (!this.api.getBoolean("asyn")) {
            ArrayList<Object> output = new ArrayList<Object>(variables.size());
            int index = 0;
            index = this.setIdAndOutput(output, index);
            Map<String, Object> outVar = this.getOutputVariablesMap(variables, output, index);
            HashMap<String, Object> requires = new HashMap<String, Object>(2);
            requires.put("id", 1);
            requires.put("output", outVar);
            this.setSample(requires, "outputSample", null, false);
            this.info.put("output_table", output);
        } else {
            HashMap<String, Object> requires = new HashMap<String, Object>(1);
            requires.put("id", 1);
            this.setSample(requires, "outputSample", null, false);
            this.setAsynOutput(variables);
        }
    }

    private void setAsynOutput(List<? extends Variable> variables) {
        int indek = 0;
        ArrayList<Object> asynOutput = new ArrayList<Object>(variables.size() + 5);
        indek = this.setIdAndNumberState(asynOutput, indek);
        Map<String, Object> outVar = this.getOutputVariablesMap(variables, asynOutput, indek);
        HashMap<String, Object> asynRequires = new HashMap<String, Object>(2);
        asynRequires.put("id", "1");
        asynRequires.put("number", "1");
        asynRequires.put("state", "complete");
        asynRequires.put("output", outVar);
        asynRequires.put("log", "if limit>0,the log will be displayed.");
        this.info.put("asynurl", "/kapi/app/iscb/SFApiOutputDispatcher");
        this.info.put("asynOutputTable", asynOutput);
        this.setSample(asynRequires, "asynOutputSample", null, false);
    }

    private Map<String, Object> getOutputVariablesMap(List<? extends Variable> variables, List<Object> output, int index) {
        HashMap<String, Object> outVar = new HashMap<String, Object>(variables.size());
        int line = 0;
        for (Variable variable : variables) {
            String dataType = D.s((Object)variable.getType());
            this.setTableColumByVariable(index, variable, dataType, output, line++, 1, variables.size());
            String defaultValue = variable.getInitValue() == null ? null : ((String[])variable.getInitValue())[0];
            this.setSampleStruct(outVar, variable, defaultValue);
            if (!ApiToXmlUtil.isVariant(dataType)) continue;
            index = this.setSampleVariant(output, index, variable, 2);
        }
        return outVar;
    }

    private int setIdAndOutput(List<Object> output, int index) {
        HashMap<String, Object> it = new HashMap<String, Object>(5);
        it.put("index", ++index);
        it.put("field", "id");
        it.put("dataType", ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"ExportServiceFlowApiToXml_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        it.put("isArray", "");
        it.put("desc", ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bid", (String)"ExportServiceFlowApiToXml_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        output.add(it);
        HashMap<String, Object> it1 = new HashMap<String, Object>(5);
        it1.put("index", ++index);
        it1.put("field", "output");
        it1.put("dataType", ResManager.loadKDString((String)"\u8f93\u51fa\u7ed3\u6784", (String)"ExportServiceFlowApiToXml_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        it1.put("isArray", "");
        it1.put("desc", ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570", (String)"ExportServiceFlowApiToXml_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        output.add(it1);
        return index;
    }

    private int setIdAndNumberState(List<Object> output, int index) {
        HashMap<String, Object> it = new HashMap<String, Object>(5);
        it.put("index", ++index);
        it.put("field", "id");
        it.put("dataType", ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"ExportServiceFlowApiToXml_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        it.put("isArray", "");
        it.put("desc", ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bid", (String)"ExportServiceFlowApiToXml_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        output.add(it);
        HashMap<String, Object> it1 = new HashMap<String, Object>(5);
        it1.put("index", ++index);
        it1.put("field", "number");
        it1.put("dataType", ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"ExportServiceFlowApiToXml_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        it1.put("isArray", "");
        it1.put("desc", ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u7f16\u7801", (String)"ExportServiceFlowApiToXml_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        output.add(it1);
        HashMap<String, Object> it2 = new HashMap<String, Object>(5);
        it2.put("index", ++index);
        it2.put("field", "state");
        it2.put("dataType", ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"ExportServiceFlowApiToXml_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        it2.put("isArray", "");
        it2.put("desc", ResManager.loadKDString((String)"\u6d41\u7a0b\u72b6\u6001", (String)"ExportServiceFlowApiToXml_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        output.add(it2);
        HashMap<String, Object> it3 = new HashMap<String, Object>(5);
        it3.put("index", ++index);
        it3.put("field", "output");
        it3.put("dataType", ResManager.loadKDString((String)"\u8f93\u51fa\u7ed3\u6784", (String)"ExportServiceFlowApiToXml_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        it3.put("isArray", "");
        it3.put("desc", ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570", (String)"ExportServiceFlowApiToXml_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        output.add(it3);
        return index;
    }

    private void setSampleStruct(Map<String, Object> value, Variable var, String defaultValue) {
        ServiceFlowApiDocGenerator.setSampleStructByIsVariant(value, var, defaultValue);
    }

    @Override
    protected void setInputApiStruct(DynamicObjectCollection inputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
    }

    @Override
    protected void setOutputApiStruct(DynamicObjectCollection outputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
    }

    @Override
    protected void setSample(Map<String, Object> requires, String sampleName, DynamicObject meta, boolean isInput) {
        String sample = JSON.toJSONString(requires, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replace("\t", "    ");
        sample = sample.replace("\n", "</w:t></w:r>\u3000</w:p><w:p><w:r><w:t>\u3000\u3000");
        this.info.put(sampleName, sample);
    }
}

