/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.apixml;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.AbstractExportApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.dt.D;

public class ExportTriggerApiToXml
extends AbstractExportApiToXml {
    private final String type;
    private final DynamicObject schema;
    private final DynamicObject meta;

    public ExportTriggerApiToXml(DynamicObject api) {
        super(api);
        this.apiInfo = new ApiInfo("/kapi/app/iscb/trigger", "", D.s((Object)api.get("number")), "isc_apic_by_dc_trigger");
        this.type = api.getString("execution_type");
        this.schema = BusinessDataServiceHelper.loadSingle((Object)api.get("data_copy_id"), (String)"isc_data_copy");
        this.meta = BusinessDataServiceHelper.loadSingle((Object)this.schema.getDynamicObject("source_schema").getPkValue(), (String)"isc_metadata_schema");
    }

    public static void setPushInputApiStruct(DynamicObjectCollection inputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier, DynamicObject meta, DynamicObject schema) {
        for (DynamicObject it : inputs) {
            String dataType;
            String mappingSrcColumn = it.getString("mapping_src_column");
            if (mappingSrcColumn.isEmpty()) continue;
            List<String> alias = ApiToXmlUtil.getAlias(schema);
            int i = mappingSrcColumn.indexOf(46);
            if (!alias.isEmpty() && i > 0 && alias.contains(mappingSrcColumn.substring(0, i))) {
                DynamicObject smeta = ApiToXmlUtil.getMetaByAlias(schema, mappingSrcColumn.substring(0, i));
                dataType = ApiToXmlUtil.getProperty(smeta, mappingSrcColumn.substring(i + 1), "data_type");
                String srcDesc = ApiToXmlUtil.getProperty(smeta, mappingSrcColumn.substring(i + 1), "prop_label");
                apiStruct.put(mappingSrcColumn, new ApiToXmlPropStruct(mappingSrcColumn, dataType, srcDesc));
            } else {
                dataType = ApiToXmlUtil.getProperty(meta, mappingSrcColumn, "data_type");
                String srcDesc = ApiToXmlUtil.getProperty(meta, mappingSrcColumn, "prop_label");
                apiStruct.put(mappingSrcColumn, new ApiToXmlPropStruct(mappingSrcColumn, dataType, srcDesc));
            }
            if (ApiToXmlUtil.isEntries(dataType)) continue;
            supplier.add(it);
        }
    }

    public static void setExecuteInputApiStruct(DynamicObjectCollection inputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        for (DynamicObject it : inputs) {
            String paramsName = it.getString("params_name");
            String paramsDataType = it.getString("params_data_type");
            String paramsLabel = it.getString("params_label");
            apiStruct.put(paramsName, new ApiToXmlPropStruct(paramsName, paramsDataType, paramsLabel));
            if (ApiToXmlUtil.isEntries(paramsDataType)) continue;
            supplier.add(it);
        }
    }

    @Override
    protected String getFileName() {
        String fileName;
        switch (this.api.getString("execution_type")) {
            case "PUSH": {
                fileName = "xml/triggerPushTemplete.xml";
                break;
            }
            case "EXECUTE": {
                fileName = "xml/triggerExecuteTemplete.xml";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u63a5\u53e3\u7c7b\u578b-%s", (String)"ExportTriggerApiToXml_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.api.getString("execution_type")));
            }
        }
        return fileName;
    }

    @Override
    protected void setInputTable() {
        switch (this.type) {
            case "PUSH": {
                DynamicObjectCollection params = this.schema.getDynamicObjectCollection("mapping_entries");
                this.setTable(params, "mapping_src_column", this.meta, ApiToXmlUtil.isInput("mapping_src_column"));
                break;
            }
            case "EXECUTE": {
                DynamicObjectCollection params = this.schema.getDynamicObjectCollection("param_entries");
                this.setTable(params, "params_name", null, ApiToXmlUtil.isInput("params_name"));
                break;
            }
        }
    }

    @Override
    protected void setInputApiStruct(DynamicObjectCollection inputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        switch (this.type) {
            case "EXECUTE": {
                ExportTriggerApiToXml.setExecuteInputApiStruct(inputs, apiStruct, supplier);
                break;
            }
            case "PUSH": {
                ExportTriggerApiToXml.setPushInputApiStruct(inputs, apiStruct, supplier, this.meta, this.schema);
                break;
            }
        }
    }

    @Override
    protected void setSample(Map<String, Object> requires, String sampleName, DynamicObject meta, boolean isInput) {
        String sample = null;
        if (isInput) {
            switch (this.type) {
                case "PUSH": {
                    JSONObject data = JsonSampleUtil.parseRequires(meta.getLong("id"), requires);
                    sample = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replace("\t", "    ");
                    break;
                }
                case "EXECUTE": {
                    sample = JSON.toJSONString(requires, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replace("\t", "    ");
                    break;
                }
            }
        }
        sample = sample != null ? sample.replace("\n", "</w:t></w:r>\u3000</w:p><w:p><w:r><w:t>\u3000\u3000") : null;
        this.info.put(sampleName, sample);
    }

    @Override
    protected void setOutputTable() {
    }

    @Override
    protected void setOutputApiStruct(DynamicObjectCollection outputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
    }

    @Override
    protected void setInput(ApiToXmlPropStruct it, int ik, int deep, int line, int size) {
        ArrayList input = (ArrayList)this.info.get("input_table");
        if (input == null) {
            input = new ArrayList(8);
        }
        HashMap<String, Object> item = new HashMap<String, Object>(7);
        item.put("index", ik);
        item.put("field", ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(this.meta, it.getName()));
        String dataType = CommonUtil.isEmpty(it.getDataType()) ? ApiToXmlUtil.getProperty(this.meta, it.getName(), "data_type") : it.getDataType();
        item.put("dataType", dataType);
        String desc = CommonUtil.isEmpty(it.getDesc()) ? ApiToXmlUtil.getProperty(this.meta, it.getName(), "prop_label") : it.getDesc();
        item.put("desc", ApiToXmlUtil.formatDesc(desc));
        input.add(item);
        this.info.put("input_table", input);
    }
}

