/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.external;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.external.DocBuilder;
import kd.isc.iscb.platform.core.connector.apic.doc.external.Pdf;
import kd.isc.iscb.platform.core.connector.apic.doc.external.style.CellStyle;

public abstract class AbstractDocBuilder
implements DocBuilder {
    @Override
    public Pdf preparePdf() {
        File file = DocFileUtil.newTempFile();
        String filePath = file.getAbsolutePath();
        try {
            OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            Document pdf = new Document(PageSize.A4);
            PdfWriter.getInstance((Document)pdf, (OutputStream)out);
            pdf.open();
            return Pdf.create(filePath, pdf);
        }
        catch (DocumentException | IOException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap(e);
        }
    }

    protected static List<PdfPCell> buildCells(String[] texts, CellStyle style, Font font) {
        ArrayList<PdfPCell> cells = new ArrayList<PdfPCell>(texts.length);
        for (String text : texts) {
            cells.add(style.buildElement(text, font));
        }
        return cells;
    }

    public Map<String, Object> parseParam(IscApiParam paramMeta) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        List<IscApiParam.Field> fields = paramMeta.getFields();
        if (fields.isEmpty()) {
            return ret;
        }
        for (IscApiParam.Field field : fields) {
            if (field.getSchema() != null) {
                Map<String, Object> innerMap = this.parseParam(field.getSchema());
                this.dealList(field, ret, innerMap);
                continue;
            }
            this.dealList(field, ret, this.getDefaultValue(field));
        }
        return ret;
    }

    private void dealList(IscApiParam.Field field, Map<String, Object> ret, Object obj) {
        if (field.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(obj);
            ret.put(field.getName(), list);
        } else {
            ret.put(field.getName(), obj);
        }
    }

    private Object getDefaultValue(IscApiParam.Field field) {
        switch (field.getDataType()) {
            case "string": {
                return "";
            }
            case "int": 
            case "long": {
                return 0;
            }
            case "decimal": {
                return BigDecimal.ZERO;
            }
            case "datetime": {
                return "1970-01-01 00:00:00";
            }
            case "boolean": {
                return Boolean.FALSE;
            }
            case "ENUM": {
                return field.getDefaultValue();
            }
            case "STRUCT": {
                return field.getDefaultValue();
            }
        }
        return null;
    }

    protected String translateType(String type) {
        switch (type) {
            case "string": {
                return ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"AbstractDocBuilder_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "int": {
                return ResManager.loadKDString((String)"\u6574\u6570", (String)"AbstractDocBuilder_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "decimal": {
                return ResManager.loadKDString((String)"\u5c0f\u6570", (String)"AbstractDocBuilder_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "datetime": {
                return ResManager.loadKDString((String)"\u65e5\u671f/\u65f6\u95f4", (String)"AbstractDocBuilder_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "long": {
                return ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"AbstractDocBuilder_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "boolean": {
                return ResManager.loadKDString((String)"\u662f/\u5426", (String)"AbstractDocBuilder_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "ENUM": {
                return ResManager.loadKDString((String)"\u679a\u4e3e", (String)"AbstractDocBuilder_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "STRUCT": {
                return ResManager.loadKDString((String)"\u7ed3\u6784", (String)"AbstractDocBuilder_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
        }
        return type;
    }
}

