/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.external;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.ApiClassify;
import kd.isc.iscb.platform.core.api.ApiUtil;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.apic.IscApiMeta;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.external.AbstractDocBuilder;
import kd.isc.iscb.platform.core.connector.apic.doc.external.Pdf;
import kd.isc.iscb.platform.core.connector.apic.doc.external.style.CellStyle;
import kd.isc.iscb.platform.core.connector.apic.doc.external.style.ParagraphStyle;
import kd.isc.iscb.platform.core.connector.apic.doc.external.style.TableStyle;
import kd.isc.iscb.util.dt.D;

public class CommonApiDocBuilder
extends AbstractDocBuilder {
    private ParagraphStyle titleStyle = new ParagraphStyle(10.0f, 1);
    private ParagraphStyle basicStyle = new ParagraphStyle(16.0f, 0);
    private CellStyle cellHeaderStyle = new CellStyle(1, 5, 0.25f, 3.0f, 1, 1);
    private CellStyle cellContentStyle = new CellStyle(0, 5, 0.25f, 3.0f, 1, 1);
    private CellStyle cellCenterStyle = new CellStyle(1, 5, 0.25f, 3.0f, 1, 1);
    private TableStyle inputStyle;
    private TableStyle outputStyle;

    public static CommonApiDocBuilder getInstance() {
        return new CommonApiDocBuilder();
    }

    private CommonApiDocBuilder() {
        List<PdfPCell> icells = CommonApiDocBuilder.buildCells(new String[]{ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"CommonApiDocBuilder_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b57\u6bb5\u540d", (String)"CommonApiDocBuilder_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"CommonApiDocBuilder_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u7ec4", (String)"CommonApiDocBuilder_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b", (String)"CommonApiDocBuilder_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b57\u6bb5\u63cf\u8ff0", (String)"CommonApiDocBuilder_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c", (String)"CommonApiDocBuilder_5", (String)"isc-iscb-platform-core", (Object[])new Object[0])}, this.cellHeaderStyle, DocFileUtil.getSpecificFont(11.0f, 1));
        float[] iwidths = new float[]{5.0f, 14.0f, 8.0f, 5.0f, 5.0f, 18.0f, 8.0f};
        this.inputStyle = new TableStyle(icells, iwidths, 100.0f, 1);
        List<PdfPCell> ocells = CommonApiDocBuilder.buildCells(new String[]{ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"CommonApiDocBuilder_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b57\u6bb5\u540d", (String)"CommonApiDocBuilder_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"CommonApiDocBuilder_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u7ec4", (String)"CommonApiDocBuilder_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b57\u6bb5\u63cf\u8ff0", (String)"CommonApiDocBuilder_4", (String)"isc-iscb-platform-core", (Object[])new Object[0])}, this.cellHeaderStyle, DocFileUtil.getSpecificFont(11.0f, 1));
        float[] owidths = new float[]{4.0f, 14.0f, 5.0f, 5.0f, 18.0f};
        this.outputStyle = new TableStyle(ocells, owidths, 100.0f, 1);
    }

    @Override
    public String addContent(IscApiMeta apiMeta, Pdf pdf) {
        try {
            return this.innerAddContent(pdf, apiMeta);
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
    }

    private String innerAddContent(Pdf pdf, IscApiMeta apiMeta) throws DocumentException {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)apiMeta.getId(), (String)apiMeta.getType(), (String)"name,description,not_publish");
        Document doc = pdf.getPdf();
        doc.add(this.titleStyle.buildElement(D.s((Object)obj.get("name")), DocFileUtil.getSpecificFont(18.0f, 0)));
        this.addBasicMessage(doc, apiMeta, obj);
        doc.add(this.basicStyle.buildElement(ResManager.loadKDString((String)"\u8f93\u5165\uff1a", (String)"CommonApiDocBuilder_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), DocFileUtil.getSpecificFont(14.0f, 0)));
        PdfPTable iTable = this.inputStyle.buildElement();
        this.createInputTable(apiMeta.getInputs(), iTable, "", 0, 1);
        doc.add((Element)iTable);
        doc.add(this.basicStyle.buildElement(ResManager.loadKDString((String)"\u8f93\u51fa\uff1a", (String)"CommonApiDocBuilder_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), DocFileUtil.getSpecificFont(14.0f, 0)));
        PdfPTable oTable = this.outputStyle.buildElement();
        this.createOutPutTable(apiMeta.getOutputs(), oTable, "", 0, 1);
        doc.add((Element)oTable);
        this.addNormalText(doc, ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a", (String)"CommonApiDocBuilder_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        String iJsonStr = this.getInputParamSimpleString(apiMeta.getInputs());
        this.addNormalText(doc, iJsonStr);
        this.addNormalText(doc, ResManager.loadKDString((String)"\u8f93\u51fa\u6837\u4f8b\uff1a", (String)"CommonApiDocBuilder_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        String oJsonStr = this.getOutputParamSimpleString(apiMeta.getDynamicObject(), apiMeta.getOutputs());
        this.addNormalText(doc, oJsonStr);
        return pdf.getPath();
    }

    private void addBasicMessage(Document doc, IscApiMeta apiMeta, DynamicObject obj) throws DocumentException {
        this.addNormalText(doc, String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s", (String)"CommonApiDocBuilder_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), apiMeta.getNumber()));
        this.addNormalText(doc, String.format(ResManager.loadKDString((String)"\u9700\u8981\u6388\u6743\uff1a%s", (String)"CommonApiDocBuilder_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.converBool(apiMeta.isAuthRequired())));
        this.addNormalText(doc, String.format(ResManager.loadKDString((String)"\u8bb0\u5f55\u65e5\u5fd7\uff1a%s", (String)"CommonApiDocBuilder_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.converBool(apiMeta.isRecordLog())));
        this.addNormalText(doc, String.format(ResManager.loadKDString((String)"\u5907\u6ce8\uff1a%s", (String)"CommonApiDocBuilder_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), obj.get("description") == null ? "" : D.s((Object)obj.get("description"))));
        String openApiNumber = ApiClassify.getPrefix(apiMeta.getType()) + apiMeta.getNumber();
        String url = ApiUtil.isVersion2Api(apiMeta.getDynamicObject()) ? "URL:/kapi/v2/iscb/route/" + openApiNumber : "URL:/kapi/app/iscb/" + openApiNumber;
        if (apiMeta.isAuthRequired()) {
            url = url + "?caller={{caller}}";
        }
        this.addNormalText(doc, url);
        this.addNormalText(doc, ResManager.loadKDString((String)"\u8c03\u7528\u65b9\u6cd5\uff1aPOST", (String)"CommonApiDocBuilder_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.addNormalText(doc, ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u90e8\uff1a", (String)"CommonApiDocBuilder_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Element table = DocFileUtil.getRequestHeaderTable(11.0f, 11.0f);
        doc.add(table);
        this.addNormalText(doc, ResManager.loadKDString((String)"\u83b7\u53d6token\u8be6\u89c1\uff1ahttps://dev.kingdee.com/index/docsNew/6668c5c0-b547-4f55-8f74-cc6ea2f5c65c", (String)"CommonApiDocBuilder_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private String converBool(boolean bool) {
        return bool ? ResManager.loadKDString((String)"\u662f", (String)"CommonApiDocBuilder_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"CommonApiDocBuilder_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    private void addNormalText(Document doc, String text) throws DocumentException {
        doc.add(this.basicStyle.buildElement(text, DocFileUtil.getSpecificFont(14.0f, 0)));
    }

    public String getInputParamSimpleString(IscApiParam paramMeta) {
        Map<String, Object> map = this.parseParam(paramMeta);
        return JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
    }

    public String getOutputParamSimpleString(DynamicObject apiMeta, IscApiParam param) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("data", this.parseParam(param));
        if (ApiUtil.isVersion2Api(apiMeta)) {
            map.put("status", Boolean.TRUE);
            map.put("errorCode", null);
            map.put("message", null);
        } else {
            map.put("success", Boolean.TRUE);
            map.put("errorCode", "success");
        }
        return JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
    }

    private int createInputTable(IscApiParam paramMeta, PdfPTable table, String preFix, int deep, int index) {
        List<IscApiParam.Field> fields = paramMeta.getFields();
        Font tableContentFont = DocFileUtil.getSpecificFont(11.0f, 0);
        for (int i = 0; i < fields.size(); ++i) {
            IscApiParam.Field field = fields.get(i);
            this.addCell(table, this.cellHeaderStyle, D.s((Object)index++), tableContentFont);
            this.addCell(table, this.cellContentStyle, preFix + this.getTabChar(deep, i, fields.size()) + field.getName(), tableContentFont);
            this.addCell(table, this.cellCenterStyle, this.translateType(field.getDataType()), tableContentFont);
            this.addCell(table, this.cellCenterStyle, this.converBool(field.isArray()), tableContentFont);
            this.addCell(table, this.cellCenterStyle, this.converBool(field.isRequired()), tableContentFont);
            this.addCell(table, this.cellContentStyle, field.getTitle(), tableContentFont);
            this.addCell(table, this.cellContentStyle, D.s((Object)field.getDefaultValue()), tableContentFont);
            if (field.getSchema() == null) continue;
            index = this.createInputTable(field.getSchema(), table, preFix + "    ", deep + 1, index);
        }
        return index;
    }

    private int createOutPutTable(IscApiParam paramMeta, PdfPTable table, String preFix, int deep, int index) {
        List<IscApiParam.Field> fields = paramMeta.getFields();
        Font tableContentFont = DocFileUtil.getSpecificFont(11.0f, 0);
        for (int i = 0; i < fields.size(); ++i) {
            IscApiParam.Field field = fields.get(i);
            this.addCell(table, this.cellHeaderStyle, D.s((Object)index++), tableContentFont);
            this.addCell(table, this.cellContentStyle, preFix + this.getTabChar(deep, i, fields.size()) + field.getName(), tableContentFont);
            this.addCell(table, this.cellCenterStyle, this.translateType(field.getDataType()), tableContentFont);
            this.addCell(table, this.cellCenterStyle, this.converBool(field.isArray()), tableContentFont);
            this.addCell(table, this.cellContentStyle, field.getTitle(), tableContentFont);
            if (field.getSchema() == null) continue;
            index = this.createOutPutTable(field.getSchema(), table, preFix + "    ", deep + 1, index);
        }
        return index;
    }

    private String getTabChar(int deep, int index, int len) {
        if (deep == 0) {
            return "";
        }
        if (index < len - 1) {
            return "\u251c ";
        }
        return "\u2514 ";
    }

    private void addCell(PdfPTable table, CellStyle style, String text, Font font) {
        table.addCell(style.buildElement(text, font));
    }
}

