/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.external.style;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import kd.isc.iscb.platform.core.connector.apic.doc.external.style.Style;

public class CellStyle
implements Style {
    private int horizontalAlign;
    private int verticalAlign;
    private float borderWidth;
    private float padding;
    private int rowSpan;
    private int colSpan;

    public PdfPCell buildElement() {
        PdfPCell cell = new PdfPCell();
        cell.setBorderWidth(this.borderWidth);
        cell.setPadding(this.padding);
        cell.setRowspan(this.rowSpan);
        cell.setColspan(this.colSpan);
        cell.setHorizontalAlignment(this.horizontalAlign);
        cell.setVerticalAlignment(this.verticalAlign);
        return cell;
    }

    public PdfPCell buildElement(String text, Font font) {
        PdfPCell cell = this.buildElement();
        Phrase phrase = new Phrase();
        phrase.setFont(font);
        if (text != null) {
            phrase.add((Element)new Chunk(text, font));
        }
        cell.setPhrase(phrase);
        return cell;
    }

    public PdfPCell buildElement(Element child) {
        PdfPCell cell = this.buildElement();
        cell.addElement(child);
        return cell;
    }

    public CellStyle(int horizontalAlign, int verticalAlign, float borderWidth, float padding, int rowSpan, int colSpan) {
        this.horizontalAlign = horizontalAlign;
        this.verticalAlign = verticalAlign;
        this.borderWidth = borderWidth;
        this.padding = padding;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
    }
}

