/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.meta;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.ApiClassify;
import kd.isc.iscb.platform.core.api.ApiUtil;
import kd.isc.iscb.platform.core.api.openapi.v2.IscApiUtil;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.Const;
import kd.isc.iscb.platform.core.connector.apic.doc.meta.EnumParamFormatter;
import kd.isc.iscb.platform.core.connector.apic.doc.meta.InputParamFormatter;
import kd.isc.iscb.platform.core.connector.apic.doc.meta.OutputParamFormatter;
import kd.isc.iscb.platform.core.connector.apic.doc.meta.QueryInputParamFormatter;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class MetaApiDocBuilder
implements Const {
    private String filePath;
    private Document pdf;
    private OutputStream out;
    private DynamicObject api;
    private DynamicObject meta;
    private boolean isQueryType;
    private static final String ENTRIES_TYPE = "ENTRIES";
    private static final String ENUM_TYPE = "ENUM";
    private static final String REF_TYPE = "REF";
    private static final String QUERY_OPER = "QUERY";
    private static final String META_ENTITY = "isc_metadata_schema";
    private static final String DATA_TYPE_STR = "data_type";
    private static final String META_ENTRY_ENTITY = "prop_entryentity";
    private static final String PROP_NAME_STR = "prop_name";
    public static final String INPUT_DATA_TYPE_STR = "input_data_type";
    public static final String INPUT_FIELD_STR = "input_field";
    public static final String OUTPUT_DATA_TYPE_STR = "output_data_type";
    public static final String OUTPUT_FIELD_STR = "output_field";
    public static final String PROP_LABEL = "prop_label";
    private static final String EXECUTE = "EXECUTE";
    private static final String OPERATION = "operation";
    public static final String PARAM_ENTRYENTITY = "param_entryentity";
    private static final String FILTER_ENTRIES = "filter_entries";
    private static final Log logger = LogFactory.getLog(MetaApiDocBuilder.class);

    public MetaApiDocBuilder(DynamicObject api) {
        this.api = api;
        this.meta = BusinessDataServiceHelper.loadSingle((Object)api.getLong("metadata_id"), (String)META_ENTITY);
        this.isQueryType = QUERY_OPER.equals(api.getString(OPERATION));
    }

    public String build() {
        try {
            this.preparePdfFile();
            this.buildMainInfoTable();
            HashMap<Pair<String, String>, String> refObjs = new HashMap<Pair<String, String>, String>();
            this.addInputJsonExample();
            this.buildInputTable(refObjs);
            this.addOutputJsonExample();
            this.buildOutputTable(refObjs);
            String type = this.meta.getString("type");
            if (!(MetaType.TABLE.name().equals(type) || MetaType.VIEW.name().equals(type) || refObjs.isEmpty())) {
                this.pdf.newPage();
                this.addContent(ResManager.loadKDString((String)"\u679a\u4e3e\u7c7b\u578b\u6570\u636e\u7ed3\u6784", (String)"MetaApiDocBuilder_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 18.0f, 1);
                Font font = DocFileUtil.getSpecificFont(12.0f, 0);
                this.appendExtendOutputInfo(font, refObjs);
            }
            String string = this.filePath;
            return string;
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
        finally {
            this.closeFile();
        }
    }

    private void addInputJsonExample() throws DocumentException {
        JSONObject inputData;
        String jsonStr;
        this.addContent(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570JSON\u793a\u4f8b\uff1a", (String)"MetaApiDocBuilder_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 16.0f, 0);
        DynamicObjectCollection inputs = this.api.getDynamicObjectCollection("inputs");
        HashMap<String, Object> requires = new HashMap<String, Object>();
        if (inputs.isEmpty()) {
            if (!EXECUTE.equals(this.api.getString(OPERATION))) {
                this.emptyInputs(requires);
            }
        } else {
            MetaApiDocBuilder.existInputsOrOutputs(inputs, requires, INPUT_DATA_TYPE_STR, INPUT_FIELD_STR);
        }
        if (StringUtil.isEmpty((String)(jsonStr = JSON.toJSONString((Object)(inputData = EXECUTE.equals(this.api.getString(OPERATION)) || MetaApiDocBuilder.hasFilter(this.api) ? JsonSampleUtil.toJSONObjectParam(this.meta.getLong("id"), requires) : JsonSampleUtil.toJSONObject(this.meta.getLong("id"), requires)), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ")))) {
            jsonStr = "{\n}";
        }
        this.addContent(jsonStr, 14.0f, 0);
    }

    public static boolean hasFilter(DynamicObject api) {
        return !CollectionUtils.isEmpty(api.getDynamicObjectCollection(FILTER_ENTRIES));
    }

    public static void existInputsOrOutputs(DynamicObjectCollection inputs, Map<String, Object> requires, String dataType, String field) {
        Supplier<Stream> supplier = () -> inputs.stream().filter(it -> !MetaApiDocBuilder.isEntries(it.getString(dataType)));
        Set<String> rootSet = supplier.get().filter(it -> !it.getString(field).contains(".")).map(it -> it.getString(field)).collect(Collectors.toSet());
        rootSet.forEach(it -> requires.put((String)it, 1));
        Map<String, Set<String>> nodeMap = supplier.get().filter(it -> it.getString(field).contains(".")).collect(Collectors.groupingBy(it -> {
            String inputField = it.getString(field);
            return inputField.substring(0, inputField.lastIndexOf(46));
        }, Collectors.mapping(it -> {
            String inputField = it.getString(field);
            return inputField.substring(inputField.lastIndexOf(46) + 1);
        }, Collectors.toSet())));
        Map<String, Set<String>> firstEntitySet = MetaApiDocBuilder.getEntityChild(null, nodeMap);
        for (Map.Entry<String, Set<String>> entry : firstEntitySet.entrySet()) {
            Map<String, Set<String>> childMap = MetaApiDocBuilder.getEntityChild(entry.getKey(), nodeMap);
            Map<String, Object> value = MetaApiDocBuilder.getNode(entry.getKey(), childMap, nodeMap);
            value.putAll(entry.getValue().stream().filter(it -> !value.containsKey(it)).collect(Collectors.toMap(it -> it, it -> 1)));
            requires.put(entry.getKey(), value);
        }
    }

    public static Map<String, Object> getNode(String parent, Map<String, Set<String>> childMap, Map<String, Set<String>> nodeMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(childMap.size());
        for (Map.Entry<String, Set<String>> entry : childMap.entrySet()) {
            String prefix = parent + "." + entry.getKey();
            Map<String, Set<String>> nextMap = MetaApiDocBuilder.getEntityChild(prefix, nodeMap);
            Map<String, Object> value = MetaApiDocBuilder.getNode(prefix, nextMap, nodeMap);
            value.putAll(entry.getValue().stream().filter(it -> !value.containsKey(it)).collect(Collectors.toMap(it -> it, it -> 1)));
            map.put(entry.getKey(), value);
        }
        return map;
    }

    public static Map<String, Set<String>> getEntityChild(String parent, Map<String, Set<String>> nodeMap) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        boolean isFirst = parent == null;
        for (Map.Entry<String, Set<String>> entry : nodeMap.entrySet()) {
            if (isFirst) {
                if (entry.getKey().contains(".")) continue;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            String path = parent + ".";
            if (!entry.getKey().startsWith(path) || entry.getKey().replaceFirst(path, "").contains(".")) continue;
            map.put(entry.getKey().substring(entry.getKey().lastIndexOf(46) + 1), entry.getValue());
        }
        return map;
    }

    private void emptyInputs(Map<String, Object> requires) {
        DynamicObjectCollection props = this.meta.getDynamicObjectCollection(META_ENTRY_ENTITY);
        for (DynamicObject prop : props) {
            String dataType = prop.getString(DATA_TYPE_STR);
            if (ENTRIES_TYPE.equals(dataType)) continue;
            requires.put(prop.getString(PROP_NAME_STR), 1);
        }
    }

    private void addOutputJsonExample() throws DocumentException {
        this.addContent(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679cJSON\u793a\u4f8b\uff1a", (String)"MetaApiDocBuilder_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 16.0f, 0);
        String jsonStr = "{\n}";
        DynamicObjectCollection outputs = this.api.getDynamicObjectCollection("outputs");
        String operation = this.api.getString(OPERATION);
        jsonStr = QUERY_OPER.equals(operation) || "SQL_EXECUTE_R".equals(operation) || EXECUTE.equals(operation) ? (outputs.isEmpty() ? this.generateDefaultOutputJsonSample(jsonStr, operation) : this.generateOutputJsonExample(outputs, operation)) : this.generateOutputJsonOfSave();
        this.addContent(jsonStr, 14.0f, 0);
    }

    private String generateOutputJsonOfSave() {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>(12);
        data.put("id", null);
        data.put("type", "");
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>(12);
        output.put("data", data);
        IscApiUtil.setOutputByVersion(output, this.api);
        String jsonStr = JSON.toJSONString(output, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
        return jsonStr;
    }

    private String generateDefaultOutputJsonSample(String jsonStr, String operation) {
        if (!EXECUTE.equals(operation)) {
            jsonStr = JsonSampleUtil.toJsonString(this.meta.getLong("id")).replaceAll("\t", "    ");
        }
        return jsonStr;
    }

    private String generateOutputJsonExample(DynamicObjectCollection outputs, String operation) {
        JSONObject outData;
        JSONObject data;
        HashMap<String, Object> requires = new HashMap<String, Object>();
        MetaApiDocBuilder.existInputsOrOutputs(outputs, requires, OUTPUT_DATA_TYPE_STR, OUTPUT_FIELD_STR);
        if (EXECUTE.equals(operation)) {
            data = JsonSampleUtil.toJSONObjectResult(this.meta.getLong("id"), requires);
            requires.forEach((k, v) -> {
                if (!data.containsKey(k)) {
                    data.put(k, v);
                }
            });
            outData = data;
        } else {
            data = JsonSampleUtil.toJSONObject(this.meta.getLong("id"), requires);
            requires.forEach((k, v) -> {
                if (!data.containsKey(k)) {
                    data.put(k, v);
                }
            });
            outData = data;
        }
        Map<String, Object> output = this.buildOutputData(outData);
        String jsonStr = JSON.toJSONString(output, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
        return jsonStr;
    }

    private Map<String, Object> buildOutputData(Object outData) {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("data", outData);
        IscApiUtil.setOutputByVersion(output, this.api);
        return output;
    }

    private void closeFile() {
        if (this.pdf != null) {
            try {
                this.pdf.close();
            }
            catch (Exception ex) {
                logger.warn("close file catch err :", (Throwable)ex);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                logger.warn("close file catch err :", (Throwable)e);
            }
        }
    }

    private void preparePdfFile() throws DocumentException {
        File file = DocFileUtil.newTempFile();
        this.filePath = file.getAbsolutePath();
        this.out = this.newOutputStream(file);
        this.pdf = new Document(PageSize.A4);
        PdfWriter.getInstance((Document)this.pdf, (OutputStream)this.out);
        this.pdf.open();
    }

    private OutputStream newOutputStream(File file) {
        try {
            return Files.newOutputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw CommonError.OUTPUT_WRITER_FAILURE.wrap((Throwable)e);
        }
    }

    private void buildMainInfoTable() throws DocumentException {
        this.addTitle();
        this.addURL();
        this.addMethod();
        this.addContentType();
    }

    private void buildInputTable(Map<Pair<String, String>, String> refObjs) throws DocumentException {
        this.addContent(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\uff1a", (String)"MetaApiDocBuilder_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 16.0f, 0);
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        DynamicObjectCollection inputs = this.api.getDynamicObjectCollection("inputs");
        if (inputs.isEmpty()) {
            if (!EXECUTE.equals(this.api.getString(OPERATION))) {
                DynamicObjectCollection list = this.meta.getDynamicObjectCollection(META_ENTRY_ENTITY);
                this.setTable(list, font, PROP_NAME_STR, ApiToXmlUtil.isInput(PROP_NAME_STR), refObjs);
            }
        } else {
            this.setTable(inputs, font, INPUT_FIELD_STR, ApiToXmlUtil.isInput(INPUT_FIELD_STR), refObjs);
        }
    }

    protected int setInputColum(PdfPTable table, Font font, String str, Map<String, Object> requires, Map<String, ApiToXmlPropStruct> apiStruct, Map<Pair<String, String>, String> inputRefObjs, int ik, int deep) {
        int line = 0;
        for (Map.Entry<String, Object> entry : requires.entrySet()) {
            ApiToXmlPropStruct apiToXmlPropStruct;
            String s = str == null ? entry.getKey() : str + '.' + entry.getKey();
            ApiToXmlPropStruct apiToXmlPropStruct2 = apiToXmlPropStruct = apiStruct.get(s) == null ? new ApiToXmlPropStruct(s, null, null) : apiStruct.get(s);
            if (entry.getValue() instanceof Integer && ApiToXmlUtil.isRef(apiStruct.get(s).getDataType())) {
                apiStruct.get(s).setDesc();
            }
            this.setInput(table, font, apiToXmlPropStruct, inputRefObjs, ++ik, deep, line++, requires.size());
            if (!(entry.getValue() instanceof Map)) continue;
            ik = this.setInputColum(table, font, s, (Map)entry.getValue(), apiStruct, inputRefObjs, ik, ++deep);
            --deep;
        }
        return ik;
    }

    protected void setTable(DynamicObjectCollection params, Font font, String field, boolean isInput, Map<Pair<String, String>, String> inputRefObjs) throws DocumentException {
        ArrayList<DynamicObject> supplier = new ArrayList<DynamicObject>();
        Map<String, ApiToXmlPropStruct> apiStruct = this.setApiStruct(params, isInput, supplier);
        Map<String, Object> requires = ApiToXmlUtil.existPuts(this.meta, field, supplier);
        if (isInput) {
            PdfPTable tableWithHeader = this.isQueryType ? QueryInputParamFormatter.INSTANCE.getTableWithHeader() : InputParamFormatter.INSTANCE.getTableWithHeader();
            this.setInputColum(tableWithHeader, font, null, requires, apiStruct, inputRefObjs, 0, 0);
            this.pdf.add((Element)tableWithHeader);
        } else {
            PdfPTable tableWithHeader = OutputParamFormatter.INSTANCE.getTableWithHeader();
            this.setOutputColum(tableWithHeader, font, null, requires, apiStruct, inputRefObjs, 0, 0);
            this.pdf.add((Element)tableWithHeader);
        }
    }

    protected int setOutputColum(PdfPTable table, Font font, String str, Map<String, Object> requires, Map<String, ApiToXmlPropStruct> apiStruct, Map<Pair<String, String>, String> inputRefObjs, int ik, int deep) {
        int line = 0;
        for (Map.Entry<String, Object> entry : requires.entrySet()) {
            ApiToXmlPropStruct apiToXmlPropStruct;
            String s = str == null ? entry.getKey() : str + '.' + entry.getKey();
            ApiToXmlPropStruct apiToXmlPropStruct2 = apiToXmlPropStruct = apiStruct.get(s) == null ? new ApiToXmlPropStruct(s, null, null) : apiStruct.get(s);
            if (entry.getValue() instanceof Integer && ApiToXmlUtil.isRef(apiStruct.get(s).getDataType())) {
                apiStruct.get(s).setDesc();
            }
            this.setOutput(table, font, apiToXmlPropStruct, ++ik, inputRefObjs, deep, line++, requires.size());
            if (!(entry.getValue() instanceof Map)) continue;
            ik = this.setOutputColum(table, font, s, (Map)entry.getValue(), apiStruct, inputRefObjs, ik, ++deep);
            --deep;
        }
        return ik;
    }

    public void setOutput(PdfPTable table, Font font, ApiToXmlPropStruct it, int ik, Map<Pair<String, String>, String> inputRefObjs, int deep, int line, int size) {
        this.addCell(table, font, String.valueOf(ik), 1);
        this.addCell(table, font, ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(this.meta, it.getName()), 0);
        String desc = CommonUtil.isEmpty(it.getDesc()) ? ApiToXmlUtil.getProperty(this.meta, it.getName(), PROP_LABEL) : it.getDesc();
        this.addCell(table, font, ApiToXmlUtil.formatDesc(desc), 0);
        String type = this.getType(it);
        this.handleTypeCell(table, font, type, it.getName(), inputRefObjs);
    }

    private Map<String, ApiToXmlPropStruct> setApiStruct(DynamicObjectCollection puts, boolean isInput, List<DynamicObject> supplier) {
        HashMap<String, ApiToXmlPropStruct> apiStruct = new HashMap<String, ApiToXmlPropStruct>(puts.size());
        if (isInput) {
            this.setInputApiStruct(puts, apiStruct, supplier);
        } else {
            this.setOutputApiStruct(puts, apiStruct, supplier);
        }
        return apiStruct;
    }

    protected void setInputApiStruct(DynamicObjectCollection inputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        for (DynamicObject it : inputs) {
            Boolean jk;
            Boolean need;
            Boolean pk;
            String type;
            if (!this.api.getDynamicObjectCollection("inputs").isEmpty()) {
                String inputField = it.getString(INPUT_FIELD_STR);
                type = it.getString(INPUT_DATA_TYPE_STR);
                String inputDescription = it.getString("input_description");
                pk = it.getBoolean("input_is_pk");
                need = it.getBoolean("input_is_required");
                jk = it.getBoolean("input_is_judge_key");
                apiStruct.put(inputField, new ApiToXmlPropStruct(inputField, type, inputDescription, pk, need, jk));
                if (ApiToXmlUtil.isEntries(type)) continue;
                supplier.add(it);
                continue;
            }
            String propName = it.getString(PROP_NAME_STR);
            type = it.getString(DATA_TYPE_STR);
            String propLabel = it.getString(PROP_LABEL);
            pk = it.getBoolean("is_primary_key");
            need = it.getBoolean("required");
            jk = it.getBoolean("prop_customize");
            apiStruct.put(propName, new ApiToXmlPropStruct(propName, type, propLabel, need, pk, jk));
            if (ApiToXmlUtil.isEntries(type)) continue;
            supplier.add(it);
        }
    }

    protected void setOutputApiStruct(DynamicObjectCollection outputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        for (DynamicObject it : outputs) {
            String outputField = it.getString(OUTPUT_FIELD_STR);
            String type = it.getString(OUTPUT_DATA_TYPE_STR);
            String outputDescription = it.getString("output_description");
            apiStruct.put(outputField, new ApiToXmlPropStruct(outputField, type, outputDescription));
            if (ApiToXmlUtil.isEntries(type)) continue;
            supplier.add(it);
        }
    }

    private void buildOutputTable(Map<Pair<String, String>, String> refObjs) throws DocumentException {
        this.addContent(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u5b57\u6bb5\u8bf4\u660e\uff1a", (String)"MetaApiDocBuilder_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 16.0f, 0);
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        DynamicObjectCollection params = this.api.getDynamicObjectCollection("outputs");
        this.setTable(params, font, OUTPUT_FIELD_STR, ApiToXmlUtil.isInput(OUTPUT_FIELD_STR), refObjs);
    }

    private void appendExtendOutputInfo(Font font, Map<Pair<String, String>, String> outputRefObjs) throws DocumentException {
        for (Map.Entry<Pair<String, String>, String> map : outputRefObjs.entrySet()) {
            DynamicObject metaObj = this.getMeta(map.getValue());
            if (metaObj == null) {
                return;
            }
            this.addLinkDest((String)map.getKey().getB() + "(" + map.getValue() + ")", map.getValue());
            if (!ENUM_TYPE.equals(map.getKey().getB())) continue;
            this.buildEnumTableByMeta(metaObj, font);
        }
    }

    private DynamicObject getMeta(String number) {
        QFilter qFilter = new QFilter("group", "=", (Object)this.api.getLong("group_id")).and("number", "=", (Object)number);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)META_ENTITY, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (obj != null) {
            return BusinessDataServiceHelper.loadSingle((Object)obj.getLong("id"), (String)META_ENTITY);
        }
        return null;
    }

    private void buildEnumTableByMeta(DynamicObject enumObj, Font cellFont) throws DocumentException {
        PdfPTable tableWithHeader = EnumParamFormatter.INSTANCE.getTableWithHeader();
        if (enumObj != null) {
            DynamicObjectCollection list = enumObj.getDynamicObjectCollection("consts_entryentity");
            for (DynamicObject item : list) {
                this.appendEnumPropFromMeta(tableWithHeader, item, cellFont);
            }
        } else {
            throw new IscBizException(ResManager.loadKDString((String)"\u679a\u4e3e\u5bf9\u8c61\u4e3a\u7a7a", (String)"MetaApiDocBuilder_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        this.pdf.add((Element)tableWithHeader);
    }

    private static boolean isEntries(String type) {
        return type != null && type.startsWith(ENTRIES_TYPE);
    }

    private void appendEnumPropFromMeta(PdfPTable table, DynamicObject item, Font font) {
        this.addCell(table, font, item.getString("const_index"), 1);
        this.addCell(table, font, item.getString("const_value"), 0);
        this.addCell(table, font, item.getString("const_label"), 0);
        this.addCell(table, font, item.getString("const_remark"), 0);
    }

    private void handleTypeCell(PdfPTable table, Font font, String type, String name, Map<Pair<String, String>, String> inputRefObjs) {
        if (type != null && type.startsWith(ENUM_TYPE)) {
            int i = type.indexOf(40);
            String schema = type.substring(i + 1, type.length() - 1);
            this.addCellLink(table, font, type, schema);
            inputRefObjs.put((Pair<String, String>)new Pair((Object)name, (Object)type.substring(0, i)), schema);
        } else {
            this.addCell(table, font, type, 0);
        }
    }

    private void setInput(PdfPTable table, Font font, ApiToXmlPropStruct it, Map<Pair<String, String>, String> inputRefObjs, int ik, int deep, int line, int size) {
        this.addCell(table, font, String.valueOf(ik), 1);
        this.addCell(table, font, ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(this.meta, it.getName()), 0);
        String desc = CommonUtil.isEmpty(it.getDesc()) ? ApiToXmlUtil.getProperty(this.meta, it.getName(), PROP_LABEL) : it.getDesc();
        this.addCell(table, font, ApiToXmlUtil.formatDesc(desc), 0);
        String type = this.getType(it);
        this.handleTypeCell(table, font, type, it.getName(), inputRefObjs);
        this.addCell(table, font, it.isTrueOne() ? "Y" : "", 1);
        if (!this.isQueryType) {
            this.addCell(table, font, it.isTrueTwo() ? "Y" : "", 1);
            this.addCell(table, font, it.isTrueThree() ? "Y" : "", 1);
        }
    }

    private String getType(ApiToXmlPropStruct it) {
        String type;
        String string = type = CommonUtil.isEmpty(it.getDataType()) ? ApiToXmlUtil.getProperty(this.meta, it.getName(), DATA_TYPE_STR) : it.getDataType();
        if (ENUM_TYPE.equals(type)) {
            type = type + '(' + ApiToXmlUtil.getProperty(this.meta, it.getName(), "data_schema") + ')';
        }
        return type;
    }

    private void addCell(PdfPTable table, Font font, String text, int align) {
        PdfPCell cell = new PdfPCell();
        cell.setBorderWidth(0.25f);
        cell.setPadding(3.0f);
        cell.setRowspan(1);
        cell.setColspan(1);
        cell.setHorizontalAlignment(align);
        cell.setVerticalAlignment(5);
        Phrase phrase = new Phrase();
        phrase.setFont(font);
        if (text != null) {
            phrase.add((Element)new Chunk(text, font));
        }
        cell.setPhrase(phrase);
        table.addCell(cell);
    }

    private void addCellLink(PdfPTable table, Font font, String text, String schema) {
        PdfPCell cell = new PdfPCell();
        cell.setBorderWidth(0.25f);
        cell.setPadding(3.0f);
        cell.setRowspan(1);
        cell.setColspan(1);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        Phrase phrase = new Phrase();
        phrase.setFont(font);
        Chunk dest = new Chunk(text, DocFileUtil.getSpecificFont(10.0f, 0, Color.BLUE)).setLocalGoto(schema);
        phrase.add((Element)dest);
        cell.setPhrase(phrase);
        table.addCell(cell);
    }

    private void addContentType() throws DocumentException {
        this.addContent(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u90e8\uff1a", (String)"MetaApiDocBuilder_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 16.0f, 0);
        Element table = DocFileUtil.getRequestHeaderTable(12.0f, 12.0f);
        this.pdf.add(table);
        this.addContent(ResManager.loadKDString((String)"\u83b7\u53d6token\u8be6\u89c1\uff1ahttps://dev.kingdee.com/index/docsNew/6668c5c0-b547-4f55-8f74-cc6ea2f5c65c", (String)"CommonApiDocBuilder_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 14.0f, 0);
    }

    private void addMethod() throws DocumentException {
        this.addContent(ResManager.loadKDString((String)"\u8c03\u7528\u65b9\u6cd5\uff1aPOST", (String)"MetaApiDocBuilder_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 16.0f, 0);
    }

    private void addURL() throws DocumentException {
        String urlNew = ApiUtil.isVersion2Api(this.api) ? "URL:/kapi/v2/iscb/route/" : "URL\uff1a/kapi/app/iscb/";
        urlNew = urlNew + ApiClassify.getPrefix("isc_apic_by_meta_schema") + this.api.get("number");
        if (this.api.getBoolean("auth_required")) {
            urlNew = urlNew + "?caller={{caller}}";
        }
        this.addContent(urlNew, 16.0f, 0);
    }

    private void addTitle() throws DocumentException {
        this.addContent(this.api.getString("name"), 18.0f, 1);
    }

    private void addContent(String content, float size, int alignType) throws DocumentException {
        Paragraph p = new Paragraph();
        Font font = DocFileUtil.getSpecificFont(size, 0);
        p.setFont(font);
        if (content != null) {
            p.add((Element)new Chunk(content, font));
        }
        p.setSpacingAfter(10.0f);
        p.setAlignment(alignType);
        this.pdf.add((Element)p);
    }

    private void addLinkDest(String content, String schema) throws DocumentException {
        Paragraph p = new Paragraph();
        p.setFont(DocFileUtil.getSpecificFont(12.0f, 0));
        Chunk dest = new Chunk(content, DocFileUtil.getSpecificFont(12.0f, 0)).setLocalDestination(schema);
        p.add((Element)dest);
        p.setSpacingAfter(1.0f);
        p.setAlignment(0);
        this.pdf.add((Element)p);
    }
}

