/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.schema;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.openapi.v2.IscApiUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.Const;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.PdfGenerator;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.CommonUtil;

public abstract class AbstractDocGenerator
implements PdfGenerator,
Const {
    private static final String PROP_MESSAGE = "message";
    private static final String PROP_ERROR_CODE = "errorCode";
    private static final String PROP_DATA = "data";
    private static final String PROP_SUCCESS = "success";
    protected Document pdf;
    private DynamicObject schemaApi;
    protected DynamicObject dc;
    private ApiInfo apiInfo;
    private static final float[] WIDTHS = new float[]{8.0f, 25.0f, 35.0f, 32.0f};
    protected final DynamicObject srcMeta;
    protected final DynamicObject tarMeta;

    public AbstractDocGenerator(Document pdf, DynamicObject schemaApi, ApiInfo apiInfo) {
        this.pdf = pdf;
        this.schemaApi = schemaApi;
        this.dc = BusinessDataServiceHelper.loadSingle((Object)schemaApi.get("schema_id"), (String)"isc_data_copy");
        this.apiInfo = apiInfo;
        this.srcMeta = BusinessDataServiceHelper.loadSingle((Object)this.dc.getDynamicObject("source_schema").getPkValue(), (String)"isc_metadata_schema");
        this.tarMeta = BusinessDataServiceHelper.loadSingle((Object)this.dc.getDynamicObject("target_schema").getPkValue(), (String)"isc_metadata_schema");
    }

    protected void addBasic() throws DocumentException {
        this.addTitle();
        this.addURL();
        this.addMethod();
        this.addContentType();
    }

    protected void addTitle() throws DocumentException {
        BaseFont baseFont = DocFileUtil.getBaseFont();
        Font font = new Font(baseFont, 16.0f, 0);
        this.addText(this.schemaApi.getString("name"), font, 1);
    }

    private void addContentType() throws DocumentException {
        this.addNormalText(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u90e8\uff1a", (String)"AbstractDocGenerator_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Element table = DocFileUtil.getRequestHeaderTable(12.0f, 12.0f);
        this.pdf.add(table);
        this.addNormalText(ResManager.loadKDString((String)"\u83b7\u53d6token\u8be6\u89c1\uff1ahttps://dev.kingdee.com/index/docsNew/6668c5c0-b547-4f55-8f74-cc6ea2f5c65c", (String)"CommonApiDocBuilder_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private void addMethod() throws DocumentException {
        this.addNormalText(this.apiInfo.getMethod());
    }

    private void addURL() throws DocumentException {
        String url = this.apiInfo.getNewUrl(this.schemaApi);
        if (this.schemaApi.getBoolean("auth_required")) {
            url = url + "?caller={{caller}}";
        }
        this.addNormalText(url);
    }

    protected void addNormalText(String text) throws DocumentException {
        BaseFont baseFont = DocFileUtil.getBaseFont();
        Font font = new Font(baseFont, 14.0f, 0);
        this.addText(text, font, 0);
    }

    protected void addText(String text, Font font, int align) throws DocumentException {
        Paragraph p = new Paragraph();
        p.setFont(font);
        if (text != null) {
            p.add((Element)new Chunk(text, font));
        }
        p.setSpacingAfter(10.0f);
        p.setAlignment(align);
        this.pdf.add((Element)p);
    }

    protected void addInputAndOutputTitle(String text) throws DocumentException {
        this.addNormalText(text);
    }

    protected void setTable(DynamicObjectCollection params, String field, boolean isInput) throws DocumentException {
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        ArrayList<DynamicObject> supplier = new ArrayList<DynamicObject>();
        Map<String, ApiToXmlPropStruct> apiStruct = this.setApiStruct(params, isInput, supplier);
        DynamicObject meta = isInput ? this.srcMeta : this.tarMeta;
        Map<String, Object> requires = ApiToXmlUtil.existPuts(meta, field, supplier);
        if (isInput && !params.isEmpty()) {
            this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u5165:", (String)"AbstractDocGenerator_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        } else if (!isInput && !params.isEmpty()) {
            this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u51fa:", (String)"AbstractDocGenerator_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        PdfPTable tableWithHeader = AbstractDocGenerator.createTableHeader();
        this.setColum(tableWithHeader, font, null, requires, apiStruct, isInput, 0, 0);
        this.pdf.add((Element)tableWithHeader);
    }

    public abstract Map<String, ApiToXmlPropStruct> setApiStruct(DynamicObjectCollection var1, boolean var2, List<DynamicObject> var3);

    protected int setColum(PdfPTable table, Font font, String str, Map<String, Object> requires, Map<String, ApiToXmlPropStruct> apiStruct, boolean isInput, int ik, int deep) {
        int line = 0;
        for (Map.Entry<String, Object> entry : requires.entrySet()) {
            ApiToXmlPropStruct apiToXmlPropStruct;
            String s = str == null ? entry.getKey() : str + '.' + entry.getKey();
            ApiToXmlPropStruct apiToXmlPropStruct2 = apiToXmlPropStruct = apiStruct.get(s) == null ? new ApiToXmlPropStruct(s, null, null) : apiStruct.get(s);
            if (entry.getValue() instanceof Integer && ApiToXmlUtil.isRef(apiStruct.get(s).getDataType())) {
                apiStruct.get(s).setDesc();
            }
            this.setCell(table, font, apiToXmlPropStruct, ++ik, isInput, deep, line++, requires.size());
            if (!(entry.getValue() instanceof Map)) continue;
            ik = this.setColum(table, font, s, (Map)entry.getValue(), apiStruct, isInput, ik, ++deep);
            --deep;
        }
        return ik;
    }

    private void setCell(PdfPTable table, Font font, ApiToXmlPropStruct it, int ik, boolean isInput, int deep, int line, int size) {
        AbstractDocGenerator.addCell(table, font, String.valueOf(ik), 1);
        DynamicObject meta = isInput ? this.srcMeta : this.tarMeta;
        AbstractDocGenerator.addCell(table, font, ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(meta, it.getName()), 0);
        String dataType = CommonUtil.isEmpty(it.getDataType()) ? ApiToXmlUtil.getProperty(meta, it.getName(), "data_type") : it.getDataType();
        AbstractDocGenerator.addCell(table, font, dataType, 0);
        String desc = CommonUtil.isEmpty(it.getDesc()) ? ApiToXmlUtil.getProperty(meta, it.getName(), "prop_label") : it.getDesc();
        AbstractDocGenerator.addCell(table, font, ApiToXmlUtil.formatDesc(desc), 0);
    }

    protected static void addCell(PdfPTable table, Font font, String text, int align) {
        PdfPCell cell = new PdfPCell();
        cell.setBorderWidth(0.25f);
        cell.setPadding(3.0f);
        cell.setRowspan(1);
        cell.setColspan(1);
        cell.setHorizontalAlignment(align);
        cell.setVerticalAlignment(5);
        Phrase phrase = new Phrase();
        phrase.setFont(font);
        if (text != null) {
            phrase.add((Element)new Chunk(text, font));
        }
        cell.setPhrase(phrase);
        table.addCell(cell);
    }

    protected static PdfPTable createTableHeader() throws DocumentException {
        PdfPTable table = new PdfPTable(4);
        table.setWidths(WIDTHS);
        table.setWidthPercentage(100.0f);
        Font font = DocFileUtil.getSpecificFont(12.0f, 1);
        AbstractDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AbstractDocGenerator_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        AbstractDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"AbstractDocGenerator_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        AbstractDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"AbstractDocGenerator_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        AbstractDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u5b57\u6bb5\u63cf\u8ff0", (String)"AbstractDocGenerator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        table.setHeaderRows(1);
        return table;
    }

    protected void addErrorSample() throws DocumentException {
        LinkedHashMap<String, Object> errorOutput = new LinkedHashMap<String, Object>();
        IscApiUtil.setErrorByVersion(errorOutput, this.schemaApi);
        errorOutput.put(PROP_ERROR_CODE, "500");
        errorOutput.put(PROP_MESSAGE, ResManager.loadKDString((String)"\u9519\u8bef\u5806\u6808\u8be6\u60c5", (String)"AbstractDocGenerator_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        errorOutput.remove(PROP_DATA);
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u6837\u4f8b\uff1a", (String)"AbstractDocGenerator_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + JSON.toJSONString(errorOutput, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    "));
    }

    protected void addParamInputSample() throws DocumentException {
        DynamicObjectCollection params = this.dc.getDynamicObjectCollection("param_entries");
        if (params.isEmpty()) {
            this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a{", (String)"AbstractDocGenerator_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + ResManager.loadKDString((String)"}", (String)"AbstractDocGenerator_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        } else {
            LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
            for (DynamicObject item : params) {
                String name = item.getString("params_name");
                map.put(name, 1);
            }
            String s = JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
            this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a", (String)"AbstractDocGenerator_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s.replaceAll("\t", "    "));
        }
    }

    protected void addSourceObjectInputSample() throws DocumentException {
        Map<String, Object> requires = SQLUtil.prepareRequires(this.dc);
        LinkedHashMap<String, JSONObject> input = new LinkedHashMap<String, JSONObject>();
        JSONObject inputData = JsonSampleUtil.parseRequires(this.dc.getLong("source_schema_id"), requires);
        input.put(PROP_DATA, inputData);
        String s1 = JSON.toJSONString(input, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a", (String)"AbstractDocGenerator_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s1.replaceAll("\t", "    "));
    }

    protected void addTargetObjectOutputSample() throws DocumentException {
        Map<String, Object> target = SQLUtil.prepareTargetFields(this.dc);
        JSONObject data = JsonSampleUtil.parseRequires(this.dc.getLong("target_schema_id"), target);
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put(PROP_DATA, Collections.singletonList(data));
        IscApiUtil.setOutputByVersion(response, this.schemaApi);
        String s = JSON.toJSONString(response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u6837\u4f8b\uff1a", (String)"AbstractDocGenerator_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s.replaceAll("\t", "    "));
    }

    protected void addTargetExecutionOutputSample() throws DocumentException {
        LinkedHashMap output = new LinkedHashMap();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("id", 1);
        response.put("type", "UPDATE");
        response.put("errorMessage", "null");
        output.put(PROP_DATA, Collections.singletonList(response));
        IscApiUtil.setOutputByVersion(response, this.schemaApi);
        String s2 = JSON.toJSONString(output, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u6837\u4f8b\uff1a", (String)"AbstractDocGenerator_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s2.replaceAll("\t", "    "));
    }
}

