/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.schema;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportSchemaApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportTriggerApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.AbstractDocGenerator;

public class PullApiDocGenerator
extends AbstractDocGenerator {
    public PullApiDocGenerator(Document pdf, DynamicObject schemaApi, ApiInfo apiInfo) {
        super(pdf, schemaApi, apiInfo);
    }

    @Override
    public Map<String, ApiToXmlPropStruct> setApiStruct(DynamicObjectCollection puts, boolean isInput, List<DynamicObject> supplier) {
        HashMap<String, ApiToXmlPropStruct> apiStruct = new HashMap<String, ApiToXmlPropStruct>(puts.size());
        if (isInput) {
            ExportTriggerApiToXml.setExecuteInputApiStruct(puts, apiStruct, supplier);
        } else {
            ExportSchemaApiToXml.setTrOrPuOutputApiStruct(puts, apiStruct, supplier, this.tarMeta);
        }
        return apiStruct;
    }

    @Override
    public void generatePdf() {
        try {
            this.addBasic();
            this.addInput();
            this.addOutput();
            this.addSample();
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
    }

    private void addInput() throws DocumentException {
        DynamicObjectCollection params = this.dc.getDynamicObjectCollection("param_entries");
        this.setTable(params, "params_name", true);
    }

    private void addOutput() throws DocumentException {
        DynamicObjectCollection mappings = this.dc.getDynamicObjectCollection("mapping_entries");
        this.setTable(mappings, "mapping_tar_column", false);
    }

    private void addSample() throws DocumentException {
        this.addParamInputSample();
        this.addTargetObjectOutputSample();
        this.addErrorSample();
    }
}

