/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.schema;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.PdfPTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportTriggerApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.AbstractDocGenerator;

public class PushApiDocGenerator
extends AbstractDocGenerator {
    private static final float[] widths = new float[]{8.0f, 25.0f, 67.0f};

    public PushApiDocGenerator(Document pdf, DynamicObject meta, ApiInfo apiInfo) {
        super(pdf, meta, apiInfo);
    }

    @Override
    public Map<String, ApiToXmlPropStruct> setApiStruct(DynamicObjectCollection puts, boolean isInput, List<DynamicObject> supplier) {
        HashMap<String, ApiToXmlPropStruct> apiStruct = new HashMap<String, ApiToXmlPropStruct>(puts.size());
        ExportTriggerApiToXml.setPushInputApiStruct(puts, apiStruct, supplier, this.srcMeta, this.dc);
        return apiStruct;
    }

    @Override
    public void generatePdf() {
        try {
            this.addBasic();
            this.addInput(this.dc.getDynamicObjectCollection("mapping_entries"));
            this.addOutput();
            this.addSample();
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
    }

    private void addSample() throws DocumentException {
        this.addSourceObjectInputSample();
        this.addTargetExecutionOutputSample();
        this.addErrorSample();
    }

    private void addInput(DynamicObjectCollection mappings) throws DocumentException {
        this.setTable(mappings, "mapping_src_column", true);
    }

    private void addOutput() throws DocumentException {
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u51fa\uff1a", (String)"PushApiDocGenerator_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.createHeader(this.pdf);
        int index = 0;
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        PushApiDocGenerator.addCell(table, font, String.valueOf(++index), 1);
        PushApiDocGenerator.addCell(table, font, "id", 1);
        PushApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u4e3b\u952e", (String)"PushApiDocGenerator_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        PushApiDocGenerator.addCell(table, font, String.valueOf(++index), 1);
        PushApiDocGenerator.addCell(table, font, "type", 1);
        PushApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b", (String)"PushApiDocGenerator_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        PushApiDocGenerator.addCell(table, font, String.valueOf(++index), 1);
        PushApiDocGenerator.addCell(table, font, "errorMessage", 1);
        PushApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"PushApiDocGenerator_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.pdf.add((Element)table);
    }

    private PdfPTable createHeader(Document pdf) throws DocumentException {
        PdfPTable table = new PdfPTable(3);
        table.setWidths(widths);
        table.setWidthPercentage(100.0f);
        Font font = DocFileUtil.getSpecificFont(12.0f, 1);
        PushApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"PushApiDocGenerator_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        PushApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"PushApiDocGenerator_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        PushApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"PushApiDocGenerator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        table.setHeaderRows(1);
        return table;
    }
}

