/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.schema;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportSchemaApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportTriggerApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.AbstractDocGenerator;

public class TransferApiDocGenerator
extends AbstractDocGenerator {
    public TransferApiDocGenerator(Document pdf, DynamicObject meta, ApiInfo apiInfo) {
        super(pdf, meta, apiInfo);
    }

    @Override
    public Map<String, ApiToXmlPropStruct> setApiStruct(DynamicObjectCollection puts, boolean isInput, List<DynamicObject> supplier) {
        HashMap<String, ApiToXmlPropStruct> apiStruct = new HashMap<String, ApiToXmlPropStruct>(puts.size());
        if (isInput) {
            ExportTriggerApiToXml.setPushInputApiStruct(puts, apiStruct, supplier, this.srcMeta, this.dc);
        } else {
            ExportSchemaApiToXml.setTrOrPuOutputApiStruct(puts, apiStruct, supplier, this.tarMeta);
        }
        return apiStruct;
    }

    @Override
    public void generatePdf() {
        try {
            this.addBasic();
            DynamicObjectCollection mappings = this.dc.getDynamicObjectCollection("mapping_entries");
            this.addInput(mappings);
            this.addOutput(mappings);
            this.addSample();
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
    }

    private void addSample() throws DocumentException {
        this.addSourceObjectInputSample();
        this.addTargetObjectOutputSample();
        this.addErrorSample();
    }

    private void addInput(DynamicObjectCollection mappings) throws DocumentException {
        this.setTable(mappings, "mapping_src_column", true);
    }

    private void addOutput(DynamicObjectCollection mappings) throws DocumentException {
        this.setTable(mappings, "mapping_tar_column", false);
    }
}

