/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.curdb;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.curdb.CurrentDBConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.AbstractConnectionFactory;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.CurrentPgSqlDbType;
import kd.isc.iscb.util.db.type.MySqlDbType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;

public final class CurrentDBConnectionFactory
extends AbstractConnectionFactory {
    private DbType currentDbType;
    private static final String MYSQL_DRIVER = "com.mysql.cj.jdbc.Driver";
    private static final String PG_DRIVER = "org.postgresql.Driver";

    @Override
    public JdbcConnectionWrapper create(DynamicObject cfg) {
        String routeKey = cfg.getString("attr1").toLowerCase();
        CurrentDBConnectionFactory currentDBConFactory = new CurrentDBConnectionFactory();
        currentDBConFactory.currentDbType = this.getCurrentDbType(this.getDriverClassNameByRouteKey(routeKey));
        if (currentDBConFactory.currentDbType == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u6570\u636e\u5e93\uff1a%s\u7684\u5c5e\u6027\u5931\u8d25\u3002", (String)"CurrentDBConnectionFactory_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), routeKey));
        }
        try {
            Connection cn = TX.__getAloneConnection((String)routeKey, (boolean)true, null, (String[])new String[0]);
            return new JdbcConnectionWrapper(new CurrentDBConnectionWrapper(cn), currentDBConFactory, cfg);
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u83b7\u53d6\u5931\u8d25\u3002", (String)"CurrentDBConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
    }

    @Override
    public void test(ConnectionWrapper cn) {
    }

    @Override
    public char getQuot() {
        return ' ';
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT TOP " + topN + " " + sql.substring("SELECT".length());
        }
        throw new IllegalArgumentException(sql);
    }

    @Override
    protected String getTestSQL() {
        return "select 1";
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case TABLE: {
                return true;
            }
            case VIEW: {
                return true;
            }
        }
        return false;
    }

    @Override
    public DbType getDatabaseType() {
        if (this.currentDbType == null) {
            throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"CurrentDBConnectionFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return this.currentDbType;
    }

    private DbType getCurrentDbType(String driverClassName) {
        if (MYSQL_DRIVER.equals(driverClassName)) {
            return new MySqlDbType();
        }
        if (PG_DRIVER.equals(driverClassName)) {
            return new CurrentPgSqlDbType();
        }
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"CurrentDBConnectionFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private String getDriverClassNameByRouteKey(String routeKey) {
        RequestContext ctx = RequestContext.get();
        String tenantId = ctx.getTenantInfo().getId();
        String accountId = ctx.getAccountId();
        Account ac = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        List dbInstances = ac.getDBInstanceList();
        for (DBInstance dbInstance : dbInstances) {
            if (!dbInstance.getRouteKey().equals(routeKey)) continue;
            return D.s((Object)AccountUtils.getPropertiesByDBInstance((DBInstance)dbInstance).get("driverClassName"));
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5206\u5e93\u6807\u8bc6\u4e3a\u3010%s\u3011\u7684\u6570\u636e\u5e93\u5b9e\u4f8b,\u8bf7\u68c0\u67e5\u3002", (String)"CurrentDBConnectionFactory_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), routeKey));
    }

    @Override
    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\u4e3a\u3010\u5f53\u524d\u6570\u636e\u5e93\u3011\uff0c\u53ea\u5141\u8bb8\u8bfb\u53d6\uff0c\u4e0d\u5141\u8bb8\u5199\u5165\u3002", (String)"CurrentDBConnectionFactory_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public Response callDataHandler(ConnectionWrapper cn, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\u4e3a\u3010\u5f53\u524d\u6570\u636e\u5e93\u3011\uff0c\u53ea\u5141\u8bb8\u8bfb\u53d6\uff0c\u4e0d\u5141\u8bb8\u5199\u5165\u3002", (String)"CurrentDBConnectionFactory_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }
}

