/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.db_proxy;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.HttpConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.db_proxy.DatabaseProxyContext;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.connector.client.RemoteContext;
import kd.isc.iscb.util.connector.client.RemoteSystem;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.MySqlDbType;
import kd.isc.iscb.util.db.type.OracleDbType;
import kd.isc.iscb.util.db.type.PostgreSqlDbType;
import kd.isc.iscb.util.db.type.SqlServerDbType;
import kd.isc.iscb.util.db.type.VastbaseG100Type;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;

public final class DatabaseProxyConnectionFactory
implements JdbcConnectionFactory,
HttpConnectionFactory {
    private DatabaseProxyContext ctx;
    private static ConcurrentHashMap<String, ConcurrentHashMap<Long, String>> dbTypeCache = new ConcurrentHashMap();

    @Override
    public DbType getDatabaseType() {
        DatabaseProxyContext ctx = this.ctx;
        if (ctx == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u975e\u6cd5\u8bbf\u95ee", (String)"DatabaseProxyConnectionFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String type = DatabaseProxyConnectionFactory.getDbType(ctx);
        return new DbTypeProxy(type);
    }

    private DbType getDbType(String type) {
        if (type.contains("mysql")) {
            return new MySqlDbType();
        }
        if (type.contains("oracle")) {
            return new OracleDbType();
        }
        if (type.contains("sqlserver")) {
            return new SqlServerDbType();
        }
        if (type.contains("postgre") || type.contains("pgsql")) {
            return new PostgreSqlDbType();
        }
        if (type.contains("vastbaseg100")) {
            return new VastbaseG100Type();
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b\uff1a%s", (String)"DatabaseProxyConnectionFactory_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
    }

    @Override
    public JdbcConnectionWrapper create(DynamicObject cfg) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cfg);
        Connection cn = RemoteSystem.getConnection((RemoteContext)ctx);
        DatabaseProxyConnectionFactory dup = new DatabaseProxyConnectionFactory();
        dup.ctx = ctx;
        return new JdbcConnectionWrapper(cn, dup, cfg);
    }

    @Override
    public Table getTable(JdbcConnectionWrapper cn, String table_name) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        return RemoteSystem.getTable((RemoteContext)ctx, (String)table_name);
    }

    @Override
    public Map<String, Index> getIndexInfo(JdbcConnectionWrapper cn, String table_name) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        return RemoteSystem.getIndexInfo((RemoteContext)ctx, (String)table_name);
    }

    @Override
    public void classify(JdbcConnectionWrapper cn, Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        RemoteSystem.classify((RemoteContext)ctx, (Table)table, judgeFields, rows, for_insert, for_update);
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        return RemoteSystem.getMetaList((RemoteContext)ctx);
    }

    @Override
    public void test(ConnectionWrapper cn) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        RemoteSystem.test((RemoteContext)ctx);
    }

    @Override
    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        return RemoteSystem.getEntityInfo((RemoteContext)ctx, (String)name);
    }

    @Override
    public Map<String, Object> getEnumInfo(ConnectionWrapper cn, String name) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        return RemoteSystem.getEnumInfo((RemoteContext)ctx, (String)name);
    }

    @Override
    public Map<String, Object> getTableInfo(JdbcConnectionWrapper cn, String table_name) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        Map map = RemoteSystem.getTableInfo((RemoteContext)ctx, (String)table_name);
        if (ctx.getVersion() >= 3.0 && RemoteSystem.isEventEnabled((RemoteContext)ctx)) {
            map.put("events", this.createEvents());
        } else {
            map.put("events", Collections.emptyList());
        }
        return map;
    }

    @Override
    public void rePushEventData(ConnectionWrapper cn, List<Object> ids) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        RemoteSystem.rePushEventData((RemoteContext)ctx, ids);
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        return RemoteSystem.topSQL((RemoteContext)ctx, (String)sql, (int)topN);
    }

    @Override
    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4ee3\u7406\u4e0d\u652f\u6301\u5b9e\u4f53\u3002", (String)"DatabaseProxyConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        Connection rcn = RemoteSystem.getConnection((RemoteContext)ctx);
        try {
            Response response = TableUtil.doAction((Connection)rcn, data, (Table)mainTable, entryTables, judgeFields, actions);
            return response;
        }
        finally {
            DbUtil.close((Connection)rcn);
        }
    }

    @Override
    public boolean supportsTransaction() {
        return false;
    }

    @Override
    public Response callDataHandler(ConnectionWrapper cn, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6570\u636e\u5904\u7406\u7c7b\uff0c\u8bf7\u4f7f\u7528\u76ee\u6807\u6570\u636e\u5904\u7406\u811a\u672c\u5b9e\u73b0\u6240\u9700\u529f\u80fd\u3002", (String)"DatabaseProxyConnectionFactory_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void detachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        RemoteSystem.detachEvents((RemoteContext)ctx, (String)iscHub, (EventBindingUtil.TriggerType)type, (long)triggerId, (String)entity);
    }

    @Override
    public void attachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        RemoteSystem.attachEvents((RemoteContext)ctx, (String)iscHub, (EventBindingUtil.TriggerType)type, (long)triggerId, (String)entity, (String[])events, requires);
    }

    @Override
    public char getQuot() {
        return '\"';
    }

    @Override
    public Map<String, Object> getServiceInfo(ConnectionWrapper cn, String service_name) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case VIEW: {
                return true;
            }
            case TABLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String netSpeedTest(ConnectionWrapper cn) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        return RemoteSystem.netSpeedTest((RemoteContext)ctx);
    }

    private List<?> createEvents() {
        ArrayList list = new ArrayList(2);
        HashMap<String, String> s = new HashMap<String, String>(4);
        s.put("index", "1");
        s.put("name", "insert");
        s.put("label", ResManager.loadKDString((String)"\u63d2\u5165", (String)"DatabaseProxyConnectionFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        list.add(s);
        HashMap<String, String> u = new HashMap<String, String>(4);
        u.put("index", "2");
        u.put("name", "update");
        u.put("label", ResManager.loadKDString((String)"\u66f4\u65b0", (String)"DatabaseProxyConnectionFactory_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        list.add(u);
        return list;
    }

    @Override
    public boolean supportsEvent() {
        return true;
    }

    @Override
    public String getHttpURL(DynamicObject dynamicObject) {
        String protocal = D.s((Object)dynamicObject.getString("http_protocal"));
        if (protocal == null) {
            protocal = "http";
        }
        String url = protocal + "://" + dynamicObject.getString("server_ip") + ":" + dynamicObject.getString("server_port") + "/isc/proxy";
        return url;
    }

    private static String getDbType(DatabaseProxyContext ctx) {
        Long dbLink;
        String dbType;
        String accountId = RequestContext.get().getAccountId();
        ConcurrentHashMap<Long, String> map = dbTypeCache.get(accountId);
        if (map == null) {
            dbTypeCache.putIfAbsent(accountId, new ConcurrentHashMap());
            map = dbTypeCache.get(accountId);
        }
        if ((dbType = map.get(dbLink = Long.valueOf(ctx.getConfig().getLong("id")))) == null) {
            map.putIfAbsent(dbLink, RemoteSystem.getDbType((RemoteContext)ctx));
            dbType = map.get(dbLink);
        }
        return dbType;
    }

    public static void clearDbTypeCache() {
        dbTypeCache.clear();
    }

    @Override
    public List<String> getTables(ConnectionWrapper cn) {
        DatabaseProxyContext ctx = new DatabaseProxyContext(cn.getConfig());
        return RemoteSystem.getTables((RemoteContext)ctx);
    }

    private final class DbTypeProxy
    implements DbType {
        private DbType dbType;

        private DbTypeProxy(String type) {
            this.dbType = DatabaseProxyConnectionFactory.this.getDbType(type);
        }

        public String getDataType(Column c) {
            return this.dbType.getDataType(c);
        }

        public String qualifyTableName(String tableName) {
            return this.dbType.qualifyTableName(tableName);
        }

        public String qualifyColumnName(String columnName) {
            return this.dbType.qualifyColumnName(columnName);
        }

        public char getQuotChar() {
            return this.dbType.getQuotChar();
        }

        public void setBigQuery(Connection src) throws SQLException {
            throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4ee3\u7406\u4e0d\u5141\u8bb8\u4f5c\u4e3a\u6570\u636e\u5e93\u590d\u5236\u7684\u6570\u636e\u6e90\u3002", (String)"DatabaseProxyConnectionFactory_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }

        public void unsetBigQuery(Connection src) throws SQLException {
            throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4ee3\u7406\u4e0d\u5141\u8bb8\u4f5c\u4e3a\u6570\u636e\u5e93\u590d\u5236\u7684\u6570\u636e\u6e90\u3002", (String)"DatabaseProxyConnectionFactory_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }

        public String emtpyTableTestSQL(Table table) {
            return this.dbType.emtpyTableTestSQL(table);
        }
    }
}

