/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.db_proxy;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;

public class Util {
    private static final String FIELD_SERVER_PORT = "server_port";
    private static final String FIELD_SERVER_IP = "server_ip";
    private static final String FIELD_SQL_DATABASE = "sql_database";

    public static String getDbProxyAccessKey(DynamicObject cfg) {
        DynamicObject user = Util.getUserInfo(cfg, false);
        String key = Util.generateDbKey(cfg, user);
        if (user == null) {
            return key;
        }
        Map<String, String> info = ConnectorUtil.getThirdLoginInfo(cfg, user);
        info.put("key", key);
        String lar = NetUtil.getLocalAddress();
        info.put("ierp_server_url", UrlService.getDomainContextUrl().replace("localhost", lar));
        return Cipher.encrypt((String)Json.toString(info));
    }

    public static DynamicObject getUserInfo(DynamicObject cfg, boolean userRequired) {
        long proxy_user_id = cfg.getLong("ierp_proxy_user_id");
        if (proxy_user_id > 0L) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)proxy_user_id, (String)"bos_user");
        }
        if (!userRequired) {
            return null;
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u5fc5\u987b\u6307\u5b9a\u201c\u82cd\u7a79\u4ee3\u7406\u7528\u6237\u201d\u624d\u80fd\u751f\u6210\u8bbf\u95ee\u952e\uff01", (String)"Util_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public static String generateDbKey(DynamicObject cfg, DynamicObject user) {
        StringBuilder sb = new StringBuilder();
        sb.append(cfg.get(FIELD_SERVER_IP)).append('/');
        sb.append(cfg.get(FIELD_SERVER_PORT)).append('/');
        sb.append(cfg.get("user")).append('/');
        sb.append(cfg.get(FIELD_SQL_DATABASE)).append('/');
        sb.append(cfg.getPkValue()).append('/');
        RequestContext ctx = RequestContext.get();
        sb.append(ctx.getTenantId()).append('/');
        sb.append(ctx.getAccountId()).append('/');
        if (user != null) {
            sb.append('/').append(user.getPkValue());
            sb.append('/').append(user.get("password"));
        }
        String key = Hash.md5((String)sb.toString()).toUpperCase();
        return key;
    }

    public static String generateVersionURL(DynamicObject cfg) {
        StringBuilder url = new StringBuilder();
        String protocal = Util.getHttpProtocal(cfg);
        url.append(protocal).append("://").append(cfg.get(FIELD_SERVER_IP));
        url.append(':').append(cfg.get(FIELD_SERVER_PORT));
        url.append("/isc/proxy/version");
        return url.toString();
    }

    public static String generateURL(DynamicObject cfg) {
        StringBuilder url = new StringBuilder();
        String protocal = Util.getHttpProtocal(cfg);
        url.append(protocal).append("://").append(cfg.get(FIELD_SERVER_IP));
        url.append(':').append(cfg.get(FIELD_SERVER_PORT));
        url.append("/isc/proxy/").append(cfg.get(FIELD_SQL_DATABASE)).append('?');
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("u", cfg.get("user"));
        map.put("p", cfg.get("password"));
        map.put("d", cfg.get(FIELD_SQL_DATABASE));
        map.put("t", System.currentTimeMillis());
        map.put("r", UUID.randomUUID().toString());
        String json = Json.toString(map);
        DynamicObject user = Util.getUserInfo(cfg, false);
        String key = Util.generateDbKey(cfg, user);
        url.append(Cipher.encrypt((String)json, (String)key));
        return url.toString();
    }

    private static String getHttpProtocal(DynamicObject cfg) {
        String protocal = D.s((Object)cfg.getString("http_protocal"));
        if (protocal == null) {
            protocal = "http";
        }
        return protocal;
    }
}

