/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ftp;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ftp.FtpConnector;
import kd.isc.iscb.platform.core.connector.ftp.util.IscFtpException;
import kd.isc.iscb.platform.core.connector.ftp.util.PathInfo;
import kd.isc.iscb.platform.core.connector.sunftp.FtpFile;

public class FtpConnectionWrapper
extends ConnectionWrapper {
    private FtpConnector ftpConnector;
    private DynamicObject cfg;

    public FtpConnectionWrapper(ConnectionFactory factory, DynamicObject cfg) {
        super(factory, cfg);
        if (!(factory instanceof FtpConnector)) {
            throw this.rewriteAndReturn(new IscFtpException(String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u5b9e\u73b0FtpConnector\u63a5\u53e3\u7c7b\u3002", (String)"FtpConnectionWrapper_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), factory)));
        }
        this.ftpConnector = (FtpConnector)((Object)factory);
        this.cfg = cfg;
    }

    public List<FtpFile> list(String dirPath) {
        this.ensureFluidControl();
        try {
            return this.ftpConnector.list(this.cfg, dirPath);
        }
        catch (IscFtpException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    public boolean delete(String path) {
        this.ensureFluidControl();
        try {
            return this.ftpConnector.delete(this.cfg, path);
        }
        catch (IscFtpException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    public Object get(PathInfo pathInfo, String fileName, long restartOffset) {
        this.ensureFluidControl();
        try {
            return this.ftpConnector.get(this.cfg, pathInfo, fileName, restartOffset);
        }
        catch (IscFtpException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    public boolean put(String dirPath, String fileName, InputStream fileStream, boolean isUpdate) {
        this.ensureFluidControl();
        try {
            return this.ftpConnector.put(this.cfg, dirPath, fileName, fileStream, isUpdate);
        }
        catch (IscFtpException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    public boolean rmdir(String dirPath) {
        this.ensureFluidControl();
        try {
            return this.ftpConnector.rmdir(this.cfg, dirPath);
        }
        catch (IscFtpException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    public boolean mkdir(String dirPath) {
        this.ensureFluidControl();
        try {
            return this.ftpConnector.mkdir(this.cfg, dirPath);
        }
        catch (IscFtpException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    public boolean exists(String dirPath) {
        this.ensureFluidControl();
        try {
            return this.ftpConnector.exists(this.cfg, dirPath);
        }
        catch (IscFtpException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    public String getWorkingDirectory() {
        this.ensureFluidControl();
        try {
            return this.ftpConnector.getWorkingDirectory(this.cfg);
        }
        catch (IscFtpException e) {
            throw this.rewriteAndReturn(e);
        }
    }
}

