/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ftp.util;

import java.nio.charset.Charset;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ftp.util.FileType;
import kd.isc.iscb.platform.core.connector.ftp.util.IscFtpException;
import kd.isc.iscb.util.misc.StringUtil;

public class PathInfo {
    public static final String DOUBLE_SLASH = "//";
    private final FileType fileType;
    private final Charset charset;
    private final String dirPath;

    public PathInfo(String charsetName, String dirPath) {
        if (StringUtil.isEmpty((String)charsetName)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PathInfo_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        boolean isBin = FileType.BIN.name().equalsIgnoreCase(charsetName);
        if (isBin) {
            this.fileType = FileType.BIN;
            this.charset = null;
        } else {
            this.fileType = FileType.TXT;
            this.charset = Charset.forName(charsetName);
        }
        this.dirPath = PathInfo.getDirPath(dirPath);
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public static String getDirPath(String dirPath) {
        if (StringUtil.isEmpty((String)dirPath)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u76ee\u5f55\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PathInfo_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (dirPath.startsWith("/")) {
            if (dirPath.startsWith(DOUBLE_SLASH)) {
                dirPath = dirPath.substring(1);
            }
        } else {
            dirPath = '/' + dirPath;
        }
        return dirPath.endsWith("/") ? dirPath : dirPath + '/';
    }
}

