/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ierp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.EncryptUtils;
import kd.bos.util.PasswordEncryptUtil;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.ierp.IerpProxyContext;
import kd.isc.iscb.util.connector.InitResult;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.client.RemoteContext;
import kd.isc.iscb.util.connector.client.RemoteSystem;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class IerpUtil {
    private static final String FIELD_WEB_APP = "web_app";
    private static final String FIELD_SERVER_PORT = "server_port";
    private static final String FIELD_SERVER_IP = "server_ip";
    private static final String FIELD_TENANT = "tenant";
    private static final String FIELD_USER = "user";
    private static final String FIELD_SECRET = "password";
    private static final String FIELD_ACCOUNT = "account";
    private static final String PARAM_COMMAND = "command";
    private static final String FIELD_APP_ID = "appId";
    private static final Log logger = LogFactory.getLog(IerpUtil.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ierp.connector");

    public static void deploy(DynamicObject cfg, String ierpServerURL, String password, PermissionMode mode) {
        IerpProxyContext ctx = new IerpProxyContext(cfg);
        String url = ctx.getRemoteURL();
        String accessKey = IerpUtil.getIerpAccessKey(cfg);
        String key = IerpUtil.generateEncodeKey(ctx, cfg.getString(FIELD_APP_ID), password);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("h", Hash.md5((String)(ierpServerURL + accessKey)));
        m.put("t", System.currentTimeMillis());
        String q = Cipher.encrypt((String)Json.toString(m), (String)key);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_COMMAND, "remote_deploy");
        params.put("ierp_server_url", ierpServerURL);
        params.put("access_key", Cipher.encrypt((String)accessKey, (String)key));
        params.put("permission_mode", mode.toString());
        params.put(FIELD_APP_ID, cfg.getString(FIELD_APP_ID));
        params.put("check_content", q);
        String salt = UUID.randomUUID().toString();
        params.put("sql_key_salt", salt);
        params.put("sql_key_hash", D.s((Object)Hash.mur64((byte[])(salt + ctx.getKey()).getBytes(StandardCharsets.UTF_8))));
        NetUtil.asyncHttpInvoke((String)url, params);
    }

    public static String generateEncodeKey(IerpProxyContext ctx, String appId, String password) {
        if (StringUtil.isEmpty((String)password)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5f00\u653e\u5e94\u7528\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"IerpUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String pwd = EncryptUtils.encryptPSW((String)password);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(FIELD_APP_ID, appId);
        params.put(PARAM_COMMAND, "get_something");
        String salt = D.s((Object)ctx.invoke(params));
        try {
            return salt != null ? PasswordEncryptUtil.getEncryptedPassword((String)password, (String)salt) : pwd;
        }
        catch (Exception e) {
            logger.warn("\u52a0\u5bc6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
            return pwd;
        }
    }

    public static String generateURL(DynamicObject cfg) {
        StringBuilder url = IerpUtil.generateURI(cfg);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("u", cfg.get(FIELD_USER));
        map.put("p", cfg.get(FIELD_SECRET));
        map.put(FIELD_ACCOUNT, cfg.get(FIELD_ACCOUNT));
        map.put(FIELD_TENANT, cfg.get(FIELD_TENANT));
        map.put("t", System.currentTimeMillis());
        String json = Json.toString(map);
        DynamicObject user = IerpUtil.getProxyUser(cfg);
        String key = IerpUtil.generateIerpKey(cfg, user);
        url.append("&key=").append(Cipher.encrypt((String)json, (String)key));
        return url.toString();
    }

    public static StringBuilder generateURI(DynamicObject cfg) {
        StringBuilder uri = IerpUtil.getConnectorContextUrl(cfg);
        try {
            String token = IerpUtil.getThirdAccessToken(cfg);
            uri.append("/kapi").append("/app/iscb/IscServiceDispatcher").append("?access_token=").append(token).append("&isc_hub=").append(ConnectorUtil.getIscHub(cfg));
        }
        catch (Exception e) {
            String message = StringUtil.getMessage((Throwable)e);
            if (message.contains("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef")) {
                String accountId = D.s((Object)cfg.get(FIELD_ACCOUNT));
                String accountName = IerpUtil.getAccountName(uri.toString(), accountId);
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8d26\u5957\uff1a%1$s\uff08%2$s\uff09\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u96c6\u6210\u4e91\u201c\u8fde\u63a5\u914d\u7f6e\u201d\u4e0a\u767b\u8bb0\u7684\u4ee3\u7406\u7528\u6237\u6216\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"IerpUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), accountId, accountName), (Throwable)e);
            }
            throw new IscBizException(StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
        return uri;
    }

    public static String getAccountName(String ierp_server_url, String accountId) {
        try {
            if (ierp_server_url.endsWith("/")) {
                ierp_server_url = ierp_server_url.substring(0, ierp_server_url.length() - 1);
            }
            String fullUrl = ierp_server_url + "/auth/getAllDatacenters.do";
            return IerpUtil.getAccountNameFromRemote(accountId, fullUrl);
        }
        catch (Exception e) {
            logger.warn("\u627e\u4e0d\u5230\u8d26\u5957ID\uff1a" + accountId + "\u5bf9\u5e94\u7684\u8d26\u5957\u540d\u79f0\u3002", (Throwable)e);
            return "unknown";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAccountNameFromRemote(String accountId, String fullUrl) throws IOException {
        Reader reader = NetUtil.httpGet((String)fullUrl, (String)"utf-8");
        try {
            List dataCenters = (List)Json.toObject((Reader)reader);
            for (Map dataCenter : dataCenters) {
                if (!accountId.equals(dataCenter.get("accountId"))) continue;
                String string = D.s(dataCenter.get("accountName"));
                return string;
            }
            String string = "unknown";
            return string;
        }
        finally {
            DbUtil.close((Reader)reader);
        }
    }

    private static StringBuilder getConnectorContextUrl(DynamicObject cfg) {
        String web;
        StringBuilder uri = new StringBuilder();
        String protocol = D.s((Object)cfg.getString("http_protocal"));
        if (protocol == null) {
            protocol = "http";
        }
        uri.append(protocol).append("://").append(cfg.get(FIELD_SERVER_IP));
        int port = D.i((Object)cfg.get(FIELD_SERVER_PORT));
        if (port != 0) {
            uri.append(':').append(port);
        }
        if ((web = D.s((Object)cfg.get(FIELD_WEB_APP))) != null) {
            uri.append(web);
        }
        return uri;
    }

    public static String getIerpAccessKey(DynamicObject cfg) {
        long proxy_user_id = cfg.getLong("ierp_proxy_user_id");
        if (proxy_user_id <= 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5fc5\u987b\u6307\u5b9a\u201c\u82cd\u7a79\u4ee3\u7406\u7528\u6237\u201d\u624d\u80fd\u751f\u6210\u8bbf\u95ee\u952e\uff01", (String)"IerpUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)proxy_user_id, (String)"bos_user");
        Map<String, String> info = ConnectorUtil.getThirdLoginInfo(cfg, user);
        info.put("key", IerpUtil.generateIerpKey(cfg, user));
        return Cipher.encrypt((String)Json.toString(info));
    }

    public static String generateIerpKey(DynamicObject cfg, DynamicObject user) {
        StringBuilder sb = new StringBuilder();
        sb.append(cfg.get(FIELD_SERVER_IP)).append('/');
        sb.append(cfg.get(FIELD_SERVER_PORT)).append('/');
        sb.append(cfg.get(FIELD_USER)).append('/');
        sb.append(cfg.get(FIELD_ACCOUNT)).append('/');
        sb.append(cfg.get(FIELD_TENANT)).append('/');
        sb.append(cfg.get(FIELD_WEB_APP)).append('/');
        sb.append(cfg.getPkValue()).append('/');
        RequestContext ctx = RequestContext.get();
        sb.append(ctx.getTenantId()).append('/');
        sb.append(ctx.getAccountId()).append('/');
        if (user != null) {
            sb.append('/').append(user.getPkValue());
        }
        return Hash.md5((String)sb.toString()).toUpperCase();
    }

    public static void pushPermission(DynamicObject cfg, Map<Object, Object> permission, String adminPassword) {
        String accessKey = IerpUtil.getIerpAccessKey(cfg);
        Map info = (Map)Json.toObject((String)Cipher.decrypt((String)accessKey));
        info.put("current_data_center", cfg.getString(FIELD_ACCOUNT) + "," + cfg.getString(FIELD_TENANT));
        accessKey = Cipher.encrypt((String)Json.toString((Object)info));
        String permissionStr = Json.toString(permission);
        String data = Cipher.encrypt((String)permissionStr, (String)accessKey);
        String url = new IerpProxyContext(cfg).getRemoteURL();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PARAM_COMMAND, "push_permission");
        param.put("data", data);
        param.put("origin_data", permissionStr);
        NetUtil.asyncHttpInvoke((String)url, param);
    }

    public static String getThirdAccessToken(DynamicObject cfg) {
        DynamicObject proxyUser = IerpUtil.getProxyUser(cfg);
        Map<String, String> info = IerpUtil.getThirdLoginInfo(cfg, proxyUser);
        String key = IerpUtil.getKey(info);
        String access_token = (String)cache.get(key);
        if (access_token != null) {
            return access_token;
        }
        Map data = ConnectorCallback.getNewAccessTokenData(info);
        long expireTime = D.l(data.get("expire_time"));
        long nowTime = System.currentTimeMillis();
        long validTimeSeconds = 1800L;
        if (expireTime > 0L && expireTime > nowTime) {
            validTimeSeconds = (expireTime - nowTime) / 1000L;
            validTimeSeconds = validTimeSeconds > 1800L ? 1800L : validTimeSeconds;
        } else if (expireTime > 0L) {
            logger.error(String.format("IerpUtil.getThirdAccessToken\u65b9\u6cd5\uff1a\u8fdc\u7aef\u82cd\u7a79\u8fd4\u56de\u7684\u8fc7\u671f\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8fdc\u7aef\u8fd4\u56de\u7684\u662f\uff1a%s\uff0c\u4f46\u662f\u5f53\u524d\u65f6\u95f4\u662f\uff1a%s", expireTime, nowTime));
        }
        access_token = D.s(data.get("access_token"));
        cache.put(key, (Object)access_token, (int)validTimeSeconds);
        return access_token;
    }

    private static String getKey(Map<String, String> info) {
        return Hash.mur2digital32((Object[])new Object[]{info.get(FIELD_USER), info.get("accountId"), info.get("tenantid"), info.get(FIELD_APP_ID), info.get("appSecuret"), info.get("ierp_server_url"), info.get(FIELD_SECRET)});
    }

    public static void removeThirdAccessToken(DynamicObject cfg) {
        DynamicObject proxyUser = IerpUtil.getProxyUser(cfg);
        Map<String, String> info = IerpUtil.getThirdLoginInfo(cfg, proxyUser);
        ConnectorCallback.removeAccessToken(info);
        String key = IerpUtil.getKey(info);
        cache.remove(key);
    }

    public static Map<String, String> getThirdLoginInfo(DynamicObject cfg, DynamicObject proxyUser) {
        HashMap<String, String> info = new HashMap<String, String>();
        String appId = cfg.getString("appid");
        String appSecret = cfg.getString("appsecret");
        info.put(FIELD_APP_ID, appId);
        info.put("appSecuret", appSecret);
        info.put("accountId", cfg.getString(FIELD_ACCOUNT));
        info.put("tenantid", cfg.getString(FIELD_TENANT));
        info.put("language", cfg.getString("icid"));
        info.put("clusterName", Instance.getClusterName());
        String user = cfg.getString(FIELD_USER);
        info.put(FIELD_USER, user);
        info.put("usertype", D.isLong((String)user) ? "Mobile" : (user.contains("@") ? "Email" : "UserName"));
        info.put("connection_id", cfg.getPkValue().toString());
        info.put("connection_number", cfg.getString("number"));
        info.put("isc_hub", ConnectorUtil.getIscHub(cfg));
        info.put("isc_local_ip", NetUtil.getLocalAddress());
        info.put("ierp_server_url", IerpUtil.getConnectorContextUrl(cfg).toString());
        info.put("proxyUser", D.s((Object)proxyUser.getPkValue()));
        if (ConnectorUtil.passwordRequired()) {
            info.put(FIELD_SECRET, cfg.getString("newpwd"));
            info.put("logintype", "2");
        }
        return info;
    }

    public static DynamicObject getProxyUser(DynamicObject cfg) {
        long proxy_user_id = cfg.getLong("ierp_proxy_user_id");
        if (proxy_user_id <= 0L || !QueryServiceHelper.exists((String)"bos_user", (Object)proxy_user_id)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5f53\u524d\u82cd\u7a79\u4ee3\u7406\u7528\u6237\u6216\u7528\u6237\u4e0d\u5b58\u5728\uff01", (String)"IerpUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)proxy_user_id, (String)"bos_user");
    }

    public static String getAccountKey() {
        return RequestContext.get().getAccountId() + "," + RequestContext.get().getTenantId();
    }

    public static void undeploy(DynamicObject cfg, IerpProxyContext ctx, String iscHub, String ierpServerURL, String adminPassword) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_COMMAND, "remote_undeploy");
        params.put(FIELD_APP_ID, cfg.getString(FIELD_APP_ID));
        params.put("isc_hub", iscHub);
        params.put("check_content", IerpUtil.getCheckContent(cfg, ctx, ierpServerURL, adminPassword));
        ctx.invoke(params);
    }

    private static String getCheckContent(DynamicObject cfg, IerpProxyContext ctx, String ierpServerURL, String password) {
        String accessKey = IerpUtil.getIerpAccessKey(cfg);
        String key = IerpUtil.generateEncodeKey(ctx, cfg.getString(FIELD_APP_ID), password);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("h", Hash.md5((String)(ierpServerURL + accessKey)));
        m.put("t", System.currentTimeMillis());
        return Cipher.encrypt((String)Json.toString(m), (String)key);
    }

    public static Map<String, InitResult> checkInitState(ConnectionWrapper cn, Map<String, Object> data, String adminPassword) {
        DynamicObject cfg = cn.getConfig();
        IerpProxyContext ctx = new IerpProxyContext(cfg);
        String appId = cfg.getString(FIELD_APP_ID);
        String encryptData = IerpUtil.encryptData(ctx, appId, adminPassword, data);
        return (Map)JSON.parseObject((String)RemoteSystem.checkInitState((RemoteContext)ctx, (String)encryptData, (String)appId), (TypeReference)new TypeReference<Map<String, InitResult>>(){}, (Feature[])new Feature[0]);
    }

    public static Map<String, InitResult> initEnv(ConnectionWrapper cn, Map<String, Object> data, String adminPassword) {
        DynamicObject cfg = cn.getConfig();
        IerpProxyContext ctx = new IerpProxyContext(cfg);
        String appId = cfg.getString(FIELD_APP_ID);
        String encryptData = IerpUtil.encryptData(ctx, appId, adminPassword, data);
        return (Map)JSON.parseObject((String)RemoteSystem.initEnv((RemoteContext)ctx, (String)encryptData, (String)appId), (TypeReference)new TypeReference<Map<String, InitResult>>(){}, (Feature[])new Feature[0]);
    }

    private static String encryptData(IerpProxyContext ctx, String appId, String adminPassword, Map<String, Object> data) {
        String key = IerpUtil.generateEncodeKey(ctx, appId, adminPassword);
        String encryptData = Cipher.encrypt((String)JSON.toJSONString(data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (String)key);
        return encryptData;
    }
}

