/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.data.ServiceFlow;
import kd.isc.iscb.platform.core.connector.ischub.EventRequest;
import kd.isc.iscb.platform.core.connector.ischub.HubEventBindingCache;
import kd.isc.iscb.platform.core.connector.ischub.HubEventBindingUtil;
import kd.isc.iscb.platform.core.connector.ischub.ResourceType;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.builder.DcEventLogBuilder;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.builder.DsEventLogBuilder;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.builder.SfEventLogBuilder;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.builder.UserDefinedEventLogBuilder;
import kd.isc.iscb.platform.core.dc.e.DataCopyEvent;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowRuntime;

public class EventUtil {
    public static void attachEvents(EventBindingUtil.TriggerType triggerType, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        HubEventBindingUtil.deleteEventBindingInfo(triggerType, triggerId, entity);
        HubEventBindingUtil.saveEventBindingInfo(triggerType, triggerId, entity, events, requires);
        HubEventBindingCache.resetCache();
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)HubEventBindingCache.class.getName(), (String)"resetCacheFromMQ", (Object[])new String[]{RequestContext.get().getAccountId(), RequestContext.get().getTenantId()});
    }

    public static void detachEvents(EventBindingUtil.TriggerType triggerType, long triggerId, String entity) {
        HubEventBindingUtil.deleteEventBindingInfo(triggerType, triggerId, entity);
        HubEventBindingCache.resetCache();
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)HubEventBindingCache.class.getName(), (String)"resetCacheFromMQ", (Object[])new String[]{RequestContext.get().getAccountId(), RequestContext.get().getTenantId()});
    }

    public static void saveDcTriggerEventLog(DataCopyEvent.Type type, DataCopyParam param, Map<String, Object> src, Map<String, Object> tar, Throwable error) {
        List<EventRequest> requestList = param.getIscEvenRequests(type);
        if (requestList != null && !requestList.isEmpty()) {
            DynamicObject trigger = param.getTrigger();
            DcEventLogBuilder builder = new DcEventLogBuilder(trigger.getString("number"), D.l((Object)trigger.getPkValue()), type.name(), param, requestList);
            builder.srcData(src).tarData(tar).error(error).saveLog();
        }
    }

    public static void saveServiceFlowEventLog(String action, long flowDefId, FlowRuntime runtime) {
        List<EventRequest> requestList = HubEventBindingCache.find(ResourceType.isc_service_flow.name(), flowDefId, action);
        if (requestList != null && !requestList.isEmpty()) {
            DynamicObject flowDef = ServiceFlow.get(flowDefId);
            String flowDefNumber = flowDef.getString("number");
            new SfEventLogBuilder(flowDefNumber, flowDefId, action, runtime, requestList).saveLog();
        }
    }

    public static void saveDsTriggerEventLog(String action, DynamicObject connectionCfg, Throwable error) {
        if (HubEventBindingCache.needListen(ResourceType.isc_data_source.name())) {
            DynamicObject[] dataSourceIds;
            long connId = D.l((Object)connectionCfg.getPkValue());
            QFilter qFilter = new QFilter("dblink", "=", (Object)connId);
            for (DynamicObject dataSourceId : dataSourceIds = BusinessDataServiceHelper.load((String)ResourceType.isc_data_source.name(), (String)"id", (QFilter[])new QFilter[]{qFilter})) {
                long dsId = dataSourceId.getLong("id");
                List<EventRequest> requestList = HubEventBindingCache.find(ResourceType.isc_data_source.name(), dsId, action);
                if (requestList == null || requestList.isEmpty()) continue;
                DynamicObject dataSource = BusinessDataServiceHelper.loadSingleFromCache((Object)dsId, (String)ResourceType.isc_data_source.name());
                new DsEventLogBuilder(dataSource, connectionCfg, action, requestList, error).saveLog();
            }
        }
    }

    public static List<Long> saveUserDefinedEventLog(DynamicObject userDefinedEvent, String action, Map<String, Object> params) {
        if (userDefinedEvent == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"EventUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        long evtSchemaId = userDefinedEvent.getLong("id");
        List<EventRequest> requestList = HubEventBindingCache.find(userDefinedEvent.getDataEntityType().getName(), evtSchemaId, action);
        if (requestList != null && !requestList.isEmpty()) {
            return new UserDefinedEventLogBuilder(userDefinedEvent, action, requestList, params).saveLog();
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%1$s\u3011\u7684\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u6839\u636e\u64cd\u4f5c\u3010%2$s\u3011\u627e\u4e0d\u5230\u9700\u8981\u89e6\u53d1\u7684\u65b9\u6848\uff0c\u6b64\u6b21\u8c03\u7528\u5c06\u88ab\u4e22\u5f03", (String)"EventUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), userDefinedEvent.getString("number"), action));
    }
}

