/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.connector.ischub.EventRequest;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Json;

public class HubEventBindingCache {
    private static final String T_ISC_RES_EVT_BND = "t_isc_res_evt_bnd";
    public static final String ALL = "all";
    private static Map<String, Set<String>> EVENT_SCHEMA_TYPE_CACHE = new ConcurrentHashMap<String, Set<String>>();
    private static Map<String, List<EventRequest>> EVENT_SCHEMA_CACHE = new ConcurrentHashMap<String, List<EventRequest>>();

    public static boolean needListen(String evtSchemaType) {
        String accountId = RequestContext.get().getAccountId();
        Set<String> needListenTypes = EVENT_SCHEMA_TYPE_CACHE.get(accountId);
        return needListenTypes != null && needListenTypes.contains(evtSchemaType);
    }

    public static List<EventRequest> find(String evtSchemaType, long evtSchemaId, String action) {
        if (HubEventBindingCache.needListen(evtSchemaType)) {
            String accountId = RequestContext.get().getAccountId();
            String key = accountId + evtSchemaType + evtSchemaId + action;
            return EVENT_SCHEMA_CACHE.get(key);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void resetCache() {
        String accountId = RequestContext.get().getAccountId();
        HubEventBindingCache.removeCacheByAccountId(accountId);
        HashSet<String> evtTypeSet = new HashSet<String>(16);
        HashMap<String, List<EventRequest>> evtSchemaCache = new HashMap<String, List<EventRequest>>(16);
        ObjectReader reader = null;
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "select fevents,frequired_fields,frequired_fields_tag,ftrigger_type,ftrigger,fevt_schema,fevt_schema_type,fall_evt_schema from t_isc_res_evt_bnd";
            reader = DbUtil.executeQuery((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                HubEventBindingCache.handleDataRow(accountId, evtTypeSet, evtSchemaCache, row);
                row = (DataRow)reader.read();
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(reader);
            DbUtil.close((Connection)cn, (boolean)false);
            throw throwable;
        }
        DbUtil.close((ObjectReader)reader);
        DbUtil.close((Connection)cn, (boolean)false);
        EVENT_SCHEMA_TYPE_CACHE.put(accountId, evtTypeSet);
        EVENT_SCHEMA_CACHE.putAll(evtSchemaCache);
    }

    private static void clearCache(String accountId) {
        EVENT_SCHEMA_TYPE_CACHE.clear();
        EVENT_SCHEMA_CACHE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCacheFromMQ(String accountId, String tenantId) {
        RequestContext current = RequestContext.get();
        try {
            RequestContext new_rc = ContextUtil.createRequestContext(accountId, tenantId);
            RequestContextCreator.restoreForMQ((RequestContext)new_rc);
            HubEventBindingCache.resetCache();
        }
        finally {
            if (current != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    private static void removeCacheByAccountId(String accountId) {
        Iterator<String> iterator = EVENT_SCHEMA_CACHE.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith(accountId)) continue;
            iterator.remove();
        }
        EVENT_SCHEMA_TYPE_CACHE.remove(accountId);
    }

    private static void handleDataRow(String accountId, Set<String> evtTypeSet, Map<String, List<EventRequest>> evtSchemaCache, DataRow row) {
        String fevtSchemaType = D.s((Object)row.get((Object)"fevt_schema_type"));
        String fevtSchema = D.x((Object)row.get((Object)"fall_evt_schema")) ? ALL : D.s((Object)row.get((Object)"fevt_schema"));
        String prefix = accountId + fevtSchemaType + fevtSchema;
        String[] events = D.s((Object)row.get((Object)"fevents")).split(",");
        String frequiredFields = D.s((Object)row.get((Object)"frequired_fields"));
        if (frequiredFields == null) {
            frequiredFields = D.s((Object)row.get((Object)"frequired_fields_tag"));
        }
        String ftriggerType = D.s((Object)row.get((Object)"ftrigger_type"));
        long ftrigger = D.l((Object)row.get((Object)"ftrigger"));
        for (String event : events) {
            String key = prefix + D.s((Object)event);
            List<EventRequest> list = evtSchemaCache.get(key);
            if (list == null) {
                list = new ArrayList<EventRequest>(1);
                evtSchemaCache.put(key, list);
            }
            Map requiredFields = (Map)Json.toObject((String)frequiredFields);
            list.add(new EventRequest(ftriggerType, ftrigger, requiredFields));
        }
        evtTypeSet.add(fevtSchemaType);
    }
}

