/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.eventlog.builder;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.EventRequest;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.EventLogExtendInfo;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.IscEventLog;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.builder.EventLogBuilder;
import kd.isc.iscb.platform.core.connector.ischub.job.IscEventJob;
import kd.isc.iscb.platform.core.job.JobEngine;

public abstract class AbstractEventLogBuilder
implements EventLogBuilder {
    protected String evtSchemaType;
    protected long evtSchemaId;
    protected String evtSchemaNumber;
    protected String action;
    protected List<EventRequest> requestList;
    protected EventLogExtendInfo extendInfo;

    protected AbstractEventLogBuilder(String evtSchemaType, String evtSchemaNumber, long evtSchemaId, String action, List<EventRequest> requestList) {
        this.evtSchemaType = evtSchemaType;
        this.evtSchemaNumber = evtSchemaNumber;
        this.evtSchemaId = evtSchemaId;
        this.action = action;
        this.requestList = requestList;
    }

    @Override
    public List<Long> saveLog() {
        String title = String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u64cd\u4f5c\uff1a%3$s", (String)"AbstractEventLogBuilder_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)this.evtSchemaType).getAlias(), this.evtSchemaNumber, this.action);
        Map<String, Object> requestData = this.constructRequestData();
        DynamicObject[] eventLogs = new DynamicObject[this.requestList.size()];
        IscEventJob[] jobs = new IscEventJob[this.requestList.size()];
        ArrayList<Long> logIds = new ArrayList<Long>();
        this.createEventLogsAndJobs(title, requestData, eventLogs, jobs, logIds);
        return this.saveEventLogsAndSubmitJobs(eventLogs, jobs, logIds);
    }

    private List<Long> saveEventLogsAndSubmitJobs(DynamicObject[] eventLogs, IscEventJob[] jobs, List<Long> logIds) {
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])eventLogs);
            JobEngine.submit(jobs, new Timestamp(System.currentTimeMillis() + 15000L));
            List<Long> list = logIds;
            return list;
        }
    }

    private void createEventLogsAndJobs(String title, Map<String, Object> requestData, DynamicObject[] eventLogs, IscEventJob[] jobs, List<Long> logIds) {
        for (int i = 0; i < this.requestList.size(); ++i) {
            EventRequest eventRequest = this.requestList.get(i);
            DynamicObject iscEventLog = IscEventLog.create(this.evtSchemaType, this.evtSchemaId, this.action, eventRequest.getTriggerType(), eventRequest.getTriggerId(), this.formatData(requestData, eventRequest.getRequiredFields()), this.extendInfo);
            long logId = iscEventLog.getLong("id");
            eventLogs[i] = iscEventLog;
            jobs[i] = new IscEventJob(title, logId);
            logIds.add(logId);
        }
    }

    private Map<String, Object> formatData(Map<String, Object> srcData, Object required) {
        if (!(required instanceof Map)) {
            return srcData;
        }
        Map requiredFields = (Map)required;
        if (requiredFields.size() == 0) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(requiredFields.size());
        for (Map.Entry requiredField : requiredFields.entrySet()) {
            String fieldName = (String)requiredField.getKey();
            Object fieldVal = srcData.get(fieldName);
            if (fieldVal instanceof List) {
                this.handleListValue(requiredFields, data, fieldName, (List)fieldVal);
                continue;
            }
            if (fieldVal instanceof Map) {
                data.put(fieldName, this.formatData((Map)fieldVal, requiredFields.get(fieldName)));
                continue;
            }
            data.put(fieldName, fieldVal);
        }
        data.put("#EVENT", this.action);
        return data;
    }

    private void handleListValue(Map<String, Object> requiredFields, Map<String, Object> data, String fieldName, List listValue) {
        if (!listValue.isEmpty() && listValue.get(0) instanceof Map) {
            List listMapVal = listValue;
            ArrayList<Map<String, Object>> newListVal = new ArrayList<Map<String, Object>>(listMapVal.size());
            for (Map singleVal : listMapVal) {
                Map<String, Object> formatData = this.formatData(singleVal, requiredFields.get(fieldName));
                newListVal.add(formatData);
            }
            data.put(fieldName, newListVal);
        } else {
            data.put(fieldName, listValue);
        }
    }

    protected Map<String, Object> getBaseInfo(DynamicObject dynamicObject) {
        HashMap<String, Object> baseInfo = new HashMap<String, Object>(8);
        if (dynamicObject != null) {
            baseInfo.put("id", dynamicObject.getPkValue());
            baseInfo.put("number", dynamicObject.getString("number"));
            baseInfo.put("name", dynamicObject.get("name"));
        }
        return baseInfo;
    }
}

