/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.eventlog.builder;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ischub.EventRequest;
import kd.isc.iscb.platform.core.connector.ischub.ResourceType;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.IscEventLog;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.builder.AbstractEventLogBuilder;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.StringUtil;

public class DcEventLogBuilder
extends AbstractEventLogBuilder {
    private DataCopyParam param;
    private Map<String, Object> src;
    private Map<String, Object> tar;
    private Throwable error;
    private DynamicObject execution;

    public DcEventLogBuilder(String evtSchemaNumber, long evtSchemaId, String action, DataCopyParam param, List<EventRequest> requestList) {
        super(ResourceType.isc_data_copy_trigger.name(), evtSchemaNumber, evtSchemaId, action, requestList);
        this.param = param;
        this.execution = param.getExecution();
        this.extendInfo = IscEventLog.createOrUpdateExtendInfo(param.getHubExtendInfo(), this.execution);
    }

    public DcEventLogBuilder srcData(Map<String, Object> src) {
        this.src = src;
        return this;
    }

    public DcEventLogBuilder tarData(Map<String, Object> tar) {
        this.tar = tar;
        return this;
    }

    public DcEventLogBuilder error(Throwable error) {
        this.error = error;
        return this;
    }

    @Override
    public Map<String, Object> constructRequestData() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
        data.put("id", this.execution.getPkValue());
        data.put("number", this.execution.getString("number"));
        data.put("name", this.execution.getString("name"));
        data.put("start_time", this.execution.getString("start_time"));
        data.put("end_time", this.execution.getString("end_time"));
        data.put("trigger", this.getBaseInfo(this.param.getTrigger()));
        data.put("schema", this.getBaseInfo(this.param.getSchema()));
        if (this.src == null) {
            Counter c = this.param.getCounter();
            data.put("total_count", c.getTotalCount());
            data.put("success_count", c.getSuccessCount());
            data.put("failed_count", c.getFailedCount());
            data.put("ignored_count", c.getIgnoredCount());
        }
        data.put("src_data", this.src);
        data.put("tar_data", this.tar);
        if (this.error != null) {
            data.put("$error", StringUtil.getCascadeMessage((Throwable)this.error));
            data.put("$error_tag", this.error);
        }
        return data;
    }
}

