/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.eventlog.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ischub.EventRequest;
import kd.isc.iscb.platform.core.connector.ischub.ResourceType;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.IscEventLog;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.builder.AbstractEventLogBuilder;
import kd.isc.iscb.util.misc.StringUtil;

public class DsEventLogBuilder
extends AbstractEventLogBuilder {
    private DynamicObject dataSource;
    private DynamicObject connectionCfg;
    private Throwable error;

    public DsEventLogBuilder(DynamicObject dataSource, DynamicObject connectionCfg, String action, List<EventRequest> requestList, Throwable error) {
        super(ResourceType.isc_data_source.name(), dataSource.getString("number"), dataSource.getLong("id"), action, requestList);
        this.dataSource = dataSource;
        this.connectionCfg = connectionCfg;
        this.extendInfo = IscEventLog.createOrUpdateExtendInfo(null, dataSource);
        this.error = error;
    }

    @Override
    public Map<String, Object> constructRequestData() {
        HashMap<String, Object> requestData = new HashMap<String, Object>(16);
        requestData.put("id", this.dataSource.getPkValue());
        requestData.put("number", this.dataSource.getString("number"));
        requestData.put("name", this.dataSource.getString("name"));
        requestData.put("conn_type", this.connectionCfg.getString("database_type"));
        requestData.put("conn_state", this.connectionCfg.getString("state"));
        requestData.put("conn_id", this.connectionCfg.getPkValue());
        requestData.put("conn_number", this.connectionCfg.getString("number"));
        requestData.put("conn_name", this.connectionCfg.getString("name"));
        requestData.put("server_ip", this.connectionCfg.getString("server_ip"));
        requestData.put("server_port", this.connectionCfg.getString("server_port"));
        if (this.error != null) {
            requestData.put("$error", StringUtil.getCascadeMessage((Throwable)this.error));
            requestData.put("$error_tag", this.error);
        }
        return requestData;
    }
}

