/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.eventlog.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.cache.data.ServiceFlow;
import kd.isc.iscb.platform.core.connector.ischub.EventRequest;
import kd.isc.iscb.platform.core.connector.ischub.ResourceType;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.EventLogExtendInfo;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.IscEventLog;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.builder.AbstractEventLogBuilder;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.misc.StringUtil;

public class SfEventLogBuilder
extends AbstractEventLogBuilder {
    private long flowDefId;
    private FlowRuntime runtime;
    private DynamicObject procInst;

    public SfEventLogBuilder(String evtSchemaNumber, long evtSchemaId, String action, FlowRuntime runtime, List<EventRequest> requestList) {
        super(ResourceType.isc_service_flow.name(), evtSchemaNumber, evtSchemaId, action, requestList);
        this.flowDefId = evtSchemaId;
        this.runtime = runtime;
        this.procInst = ProcessRuntime.getProcessObj(runtime);
        this.extendInfo = IscEventLog.createOrUpdateExtendInfo(this.getExtendInfo(), this.procInst);
    }

    private EventLogExtendInfo getExtendInfo() {
        Object prop = this.runtime.getProperty("$event_ext_info");
        if (prop instanceof Map) {
            return new EventLogExtendInfo((Map)prop);
        }
        return null;
    }

    @Override
    public Map<String, Object> constructRequestData() {
        HashMap<String, Object> requestData = new HashMap<String, Object>(16);
        requestData.put("id", this.procInst.getPkValue());
        requestData.put("number", this.procInst.getString("number"));
        requestData.put("created_time", this.procInst.getDate("created_time"));
        requestData.put("modified_time", this.procInst.getDate("modified_time"));
        requestData.put("creator", this.getBaseInfo(this.procInst.getDynamicObject("creator")));
        requestData.put("modifier", this.getBaseInfo(this.procInst.getDynamicObject("modifier")));
        requestData.put("flow_r", this.getBaseInfo(this.procInst.getDynamicObject("flow")));
        requestData.put("state", this.getState(this.action));
        DynamicObject flow = ServiceFlow.get(this.flowDefId);
        requestData.put("name", flow.getString("name"));
        requestData.put("flow", this.getBaseInfo(flow));
        Map variables = this.runtime.getFlow().getVariables();
        HashMap params = new HashMap(variables.size());
        for (Map.Entry entry : variables.entrySet()) {
            params.put(entry.getKey(), this.runtime.get((String)entry.getKey()));
        }
        requestData.put("$params", params);
        Throwable error = this.runtime.getError();
        if (error != null && !(error instanceof TaskCancelException)) {
            requestData.put("$error", StringUtil.getCascadeMessage((Throwable)error));
            requestData.put("$error_tag", StringUtil.toString((Throwable)error));
        }
        return requestData;
    }

    private String getState(String action) {
        if ("end".equals(action)) {
            return "Complete";
        }
        if ("fail".equals(action)) {
            return "Failed";
        }
        if ("cancel".equals(action)) {
            return "Terminated";
        }
        return "Unknown";
    }
}

